/**********************************************************************************
 *
 * @file    interrupt.h
 * @brief   Interrupt handler
 *
 * @date    23 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Nov  2021    Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef    _Interrupt_H
#define    _Interrupt_H

#ifdef ISR_GLOBALS
    #define ISR_PUBLIC
#else
    #define ISR_PUBLIC extern
#endif

//----------------------------------------------------------------------------------------
//*************************************//
//    Public function defined        //
//*************************************//

ISR_PUBLIC void Reset_Handler(void);                // vector NO:
ISR_PUBLIC void NMI_Handler(void);                  // vector NO:
ISR_PUBLIC void HARDFAULT_Handler(void);            // vector NO:
ISR_PUBLIC void SVC_Handler(void);                  // vector NO:
ISR_PUBLIC void PENDSV_Handler(void);               // vector NO:
ISR_PUBLIC void SYSTICK_Handler(void);              // vector NO:
ISR_PUBLIC void WWDT_IRQHandler(void);              // vector NO: IRQ NO:0
ISR_PUBLIC void PVD_IRQHandler(void);               // vector NO: IRQ NO:1
ISR_PUBLIC void LowPowerWakeup_IRQHandler(void);    // vector NO: IRQ NO:3
ISR_PUBLIC void RCU_IRQHandler(void);               // vector NO: IRQ NO:4
ISR_PUBLIC void EXTI0_1_IRQHandler(void);           // vector NO: IRQ NO:5
ISR_PUBLIC void EXTI2_3_IRQHandler(void);           // vector NO: IRQ NO:6
ISR_PUBLIC void EXTI4_15_IRQHandler(void);          // vector NO: IRQ NO:7
ISR_PUBLIC void LCD_IRQHandler(void);               // vector NO: IRQ NO:10
ISR_PUBLIC void MMC_IRQHandler(void);               // vector NO: IRQ NO:11
ISR_PUBLIC void EXTI16_19_IRQHandler(void);         // vector NO: IRQ NO:12
ISR_PUBLIC void BS16T1_IRQHandler(void);            // vector NO: IRQ NO:14
ISR_PUBLIC void GP32C4T1_IRQHandler(void);          // vector NO: IRQ NO:15
ISR_PUBLIC void GP16C2T1_IRQHandler(void);          // vector NO: IRQ NO:19
ISR_PUBLIC void GP16C2T2_IRQHandler(void);          // vector NO: IRQ NO:20
ISR_PUBLIC void I2C1_IRQHandler(void);              // vector NO: IRQ NO:23
ISR_PUBLIC void SPI1_IRQHandler(void);              // vector NO: IRQ NO:25
ISR_PUBLIC void UART1_IRQHandler(void);             // vector NO: IRQ NO:27
ISR_PUBLIC void SUART1_IRQHandler(void);            // vector NO: IRQ NO:30

//**************************************//
//    Public variable defined            //
//**************************************//


#undef ISR_PUBLIC


#else
/* */
#endif
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
