/**********************************************************************************
 *
 * @file    interrupt.c
 * @brief   Interrupt C file
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#define isr_GLOBALS

#include "Interrupt.h"
#include "main.h"

__IO uint32_t    EXTI_INTR0to1;
__IO uint32_t    EXTI_INTR2to3;
__IO uint32_t    EXTI_INTR4to15;
/** @addtogroup Projects_Examples
  * @{
  */

/** @addtogroup INTERRUPT
  * @{
  */

/* Includes -------------------------------------------------------------------*/
/* Public Functions -----------------------------------------------------------*/
/* Public Init Structure ------------------------------------------------------*/
/* Public Macros --------------------------------------------------------------*/
/* Public Constants -----------------------------------------------------------*/
/* Private Variables ----------------------------------------------------------*/
/* Private Macros -------------------------------------------------------------*/
/* Private Constants-----------------------------------------------------------*/
/* Private Functions ----------------------------------------------------------*/

/** @addtogroup Exceptions Handlers
  * @{
  */

/******************************************************************/
/*                Core Processor Exceptions Handlers           */
/******************************************************************/
/**
  * @brief NMI_IRQHandler.
  * @param none
  * @retval none
  */
void NMI_Handler(void)
{
}

/**
  * @brief HardFault_IRQHandler.
  * @param none
  * @retval none
  */
void HARDFAULT_Handler(void)
{
    /* Go to infinite loop when Hard Fault exception occurs */
    while (1)
    {

    }
}

/**
  * @brief SVCall_IRQHandler.
  * @param none
  * @retval none
  */
void SVC_Handler(void)
{
}

/**
  * @brief PendSV_IRQHandler.
  * @param none
  * @retval none
  */
void PENDSV_Handler(void)
{
}

/**
  * @brief Systick_IRQHandler.
  * @param none
  * @retval none
  */
void SYSTICK_Handler(void)
{
}

/******************************************************************/
/*              External Processor Exceptions Handlers            */
/******************************************************************/
/**
  * @brief SUART1_IRQHandler.
  * @param none
  * @retval none
  */
void SUART1_IRQHandler(void)   /*  IRQ 37  */
{
    while (1);
}

/**
  * @brief UART1_IRQHandler.
  * @param none
  * @retval none
  */
void UART1_IRQHandler(void)      /*  IRQ 27 */
{
    while (1);
}

/**
  * @brief SPI1_IRQHandler.
  * @param none
  * @retval none
  */
void SPI1_IRQHandler(void)      /*  IRQ 25  */
{
    while (1);
}

/**
  * @brief I2C1_IRQHandler.
  * @param none
  * @retval none
  */
void I2C1_IRQHandler(void)      /*  IRQ 23  */
{
    while (1);
}

/**
  * @brief GP16C2T2_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C2T2_IRQHandler(void)   /*  IRQ 20  */
{
    while (1);
}

/**
  * @brief GP16C2T1_IRQHandler.
  * @param none
  * @retval none
  */
void GP16C2T1_IRQHandler(void)   /*  IRQ 19  */
{
    while (1);
}

/**
  * @brief GP32C4T1_IRQHandler.
  * @param none
  * @retval none
  */
void GP32C4T1_IRQHandler(void)   /*  IRQ 15  */
{
    while (1);
}

/**
  * @brief BS16T1_IRQHandler.
  * @param none
  * @retval none
  */
void BS16T1_IRQHandler(void)     /*  IRQ 14  */
{
    while (1);
}

/**
  * @brief EXTI16_19_IRQHandler.
  * @param none
  * @retval none
  */
void EXTI16_19_IRQHandler(void)     /*  IRQ 12  */
{
    while (1);
}

/**
  * @brief MMC_IRQHandler.
  * @param none
  * @retval none
  */
void MMC_IRQHandler(void)     /*  IRQ 11  */
{
    while (1);
}

/**
  * @brief LCD_IRQHandler.
  * @param none
  * @retval none
  */
void LCD_IRQHandler(void)     /*  IRQ 10  */
{
    while (1);
}

/**
  * @brief EXTI4_15_IRQHandler.
  * @param none
  * @retval none
  */
void EXTI4_15_IRQHandler(void)     /*  IRQ 7  */
{
    EXTI_INTR4to15 = EXTI->IFM;
    EXTI->ICR = EXTI_INTR4to15;

    printf("\r\n=======================================\r\n");
    printf("Interrupt for EXTI4_15_IRQHandler!!\r\n");
    printf("=======================================\r\n");
}

/**
  * @brief EXTI2_3_IRQHandler.
  * @param none
  * @retval none
  */
void EXTI2_3_IRQHandler(void)      /*  IRQ 6  */
{
    EXTI_INTR2to3 = EXTI->IFM;
    EXTI->ICR = EXTI_INTR2to3;

    printf("\r\n=======================================\r\n");
    printf("Interrupt for EXTI2_3_IRQHandler!!\r\n");
    printf("SWI interrupt\r\n");
    printf("=======================================\r\n");
}

/**
  * @brief EXTI0_1_IRQHandler.
  * @param none
  * @retval none
  */
void EXTI0_1_IRQHandler(void)      /*  IRQ 5  */
{
    EXTI_INTR0to1 = EXTI->IFM;
    EXTI->ICR = EXTI_INTR0to1;
    printf("\r\n=======================================\r\n");
    printf("Interrupt for EXTI0_1_IRQHandler!!\r\n");
    printf("=======================================\r\n");
}

/**
  * @brief RCU_IRQHandler.
  * @param none
  * @retval none
  */
void RCU_IRQHandler(void)       /*  IRQ 4   */
{
    while (1);
}

/**
  * @brief WAKEUP_IRQHandler.
  * @param none
  * @retval none
  */
void LowPowerWakeup_IRQHandler(void)       /*  IRQ 3   */
{
    while (1);
}

extern uint8_t intrEXTI;
/**
  * @brief PVD_IRQHandler.
  * @param none
  * @retval none
  */
void PVD_IRQHandler(void)          /*  IRQ 1  */
{
    intrEXTI = md_exti_is_masked_it_pvd(EXTI) ;  // Interrupt Status
    md_exti_clear_it_pvd(EXTI); 
}

/**
  * @brief WWDT_IRQHandler.
  * @param none
  * @retval none
  */
void WWDT_IRQHandler(void)           /*  IRQ 0  */
{
    while (1);
}

/**
  * @} Exceptions Handlers
  */

/**
  * @} INTERRUPT
  */

/**
  * @} Projects_Examples
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
