/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <stdlib.h>
#include "main.h"
#include "rbtree.h"
#include "ke.h"


/** @addtogroup Projects_Examples_Micro_Kernel
  * @{
  */

/** @addtogroup Examples
  * @{
  */

#define TEST_SIZE	800

typedef struct xx_env_s {
	rb_tree_t tree;
} xx_env_t;

typedef struct yy_entry_s {
	rb_node_t node;
	int abc;
	int bcd;
	void *func;
} yy_entry_t;

xx_env_t env;
yy_entry_t ent[TEST_SIZE];
int value;

/**
  * @brief  Compare key
  * @retval result
  */
int yy_cmp(rb_node_t *node, void *key)
{
	uint32_t tmp    = (uint32_t)key;
	yy_entry_t *ent = rb_entry(node, yy_entry_t, node);

	return tmp - ent->abc;
}


/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	int i;
	rb_node_t *_ent;
	yy_entry_t *yy;
	
	/* Initialize ALD */
	ald_cmu_init();
	/* Set system clock to 48MHz */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Initialize rbtree */
	rb_tree_init(&env.tree, yy_cmp);

	/* Insert node into tree */
	for (i = 0; i < TEST_SIZE; ++i) {
		ent[i].abc = i;
		ent[i].bcd = i + 10;
		rb_tree_insert(&env.tree, &ent[i].node, (void *)ent[i].abc);
	}

	/* Find node by key */
	_ent = rb_tree_find(&env.tree, (void *)786);

	/* Get entry */
	if (_ent != NULL) {
		yy    = rb_entry(_ent, yy_entry_t, node);
		value = yy->abc;
	}
	
	while (1) {
		;
	}
}

/**
  * @}
  */
/**
  * @}
  */
