/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <stdlib.h>
#include "main.h"
#include "ke.h"


/** @addtogroup Projects_Examples_Micro_Kernel
  * @{
  */

/** @addtogroup Examples
  * @{
  */

#define TESP_MEM_TASK_PRIO	8

uint8_t *tx_buf;
uint8_t *rx_buf;

/**
  * @brief  Callback function of test's task.
  * @param  arg: Pointer to parameter.
  * @retval None
  */
void test_mem_func(void *arg)
{
	tx_buf = (uint8_t *)ke_malloc(1024);
	rx_buf = (uint8_t *)ke_malloc(512);

	ke_free(tx_buf);
	ke_free(rx_buf);

	return;
}


/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Set system clock to 48MHz */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

        #if defined (__ICCARM__)
	ke_init(0x8000, NULL, 0x800);
        #else
	ke_init(0x8000, NULL);
        #endif

	task_create(test_mem_func, NULL, TESP_MEM_TASK_PRIO);

	/* Start kernel */
	ke_start();
	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
