/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "ke.h"


/** @addtogroup Projects_Examples_Micro_Kernel
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uart_handle_t h_uart;
ke_tmr_t *tmr0;
ke_tmr_t *tmr1;

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void uart_pin_init(void)
{
	gpio_init_t x;

	/* Initialize tx pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_5;
	ald_gpio_init(UART0_TX_PORT, UART0_TX_PIN, &x);

	/* Initialize rx pin */
	x.mode = GPIO_MODE_INPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_5;
	ald_gpio_init(UART0_RX_PORT, UART0_RX_PIN, &x);

	return;
}

/**
  * @brief  functon for timer.
  * @param  arg: Pointer to arguments
  * @retval None
  */
void tmr_cbk(void *arg)
{
	return;
}

/**
  * @brief  command for "version".
  * @retval None
  */
void cmd_version(void)
{
	printf_s("ald:    00-00-00-01\n");
	printf_s("kernel: 00-00-00-01\n");

	return;
}

/**
  * @brief  command for "test0".
  * @retval None
  */
void cmd_test(void)
{
	printf_s("cmd_test\n");
	return;
}

/**
  * @brief  command for "ke_info".
  * @retval None
  */
void cmd_ke_info(void)
{
	ke_show();
	return;
}

/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Set system clock to 48MHz */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Enable uart interrupt */
	ald_mcu_irq_config(UART0_IRQn, 3, ENABLE);
	/* clear uart_handle_t structure */
	memset(&h_uart, 0x0, sizeof(h_uart));
	/* Initialize pin */
	uart_pin_init();

	/* Initialize uart for shell */
	h_uart.perh             = UART0;
	h_uart.init.baud        = 115200;
	h_uart.init.word_length = UART_WORD_LENGTH_8B;
	h_uart.init.stop_bits   = UART_STOP_BITS_1;
	h_uart.init.parity      = UART_PARITY_NONE;
	h_uart.init.mode        = UART_MODE_UART;
	h_uart.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
	ald_uart_init(&h_uart);

        #if defined (__ICCARM__)
	ke_init(0x8000, &h_uart, 0x800);
        #else
	ke_init(0x8000, &h_uart);
        #endif
	
	shell_cmd_insert("version", (void *)cmd_version, 0);
	shell_cmd_insert("ke_info", (void *)cmd_ke_info, 0);

	/* Start kernel */
	ke_start();
	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
