/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"
#include "md_utils.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
	/* Added Emergency operation */
	return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
	/* Added debug information */
	while (1)
		;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
	/* Added system callback */
	return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
	/* Added debug operation */
	return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
	/* Added thread switching operation */
	return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
	md_inc_tick();
	return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void UART0_Handler(void)
{
	if ((md_uart_is_active_flag_txs(UARTx)) && (env.state & USR_STATE_TX)) {
		md_uart_clear_flag_txs(UARTx);
		md_uart_send_data8(UARTx, env.tx_buf[env.tx_cnt++]);

		if (env.tx_cnt == env.tx_size) {
			CLEAR_BIT(env.state, USR_STATE_TX);
			md_uart_disable_it_txs(UARTx);
			md_uart_enable_it_tc(UARTx);
		}
	}
	if ((md_uart_is_enabled_it_tc(UARTx)) && (md_uart_is_active_flag_tc(UARTx))) {
		md_uart_clear_flag_tc(UARTx);
		md_uart_disable_it_tc(UARTx);
		
		SET_BIT(env.event, USR_EVENT_TX_CPLT);
	}
	if ((md_uart_is_enabled_it_rxrd(UARTx)) && (md_uart_is_active_flag_rxrd(UARTx))) {
		md_uart_clear_flag_rxrd(UARTx);
		env.rx_buf[env.rx_cnt++] = (uint8_t)md_uart_recv_data8(UARTx);

		if (env.rx_cnt == env.rx_size) {
			md_uart_disable_it_rxrd(UARTx);
			CLEAR_BIT(env.state, USR_STATE_RX);
			SET_BIT(env.event, USR_EVENT_RX_CPLT);
		}
	}

	return;
}

/**
  * @}
  */

/**
  * @}
  */
