/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  gpio init
  * @param  None
  * @retval None
  */
void gpio_init(void)
{
	/* Config gpio */
	md_gpio_set_pin_mode_output(TIMER0_CHANNEL_PORT, TIMER0_CHANNEL1_PIN);
	md_gpio_set_pin_drive_normal(TIMER0_CHANNEL_PORT, TIMER0_CHANNEL1_PIN);
	md_gpio_set_pin_push_up(TIMER0_CHANNEL_PORT, TIMER0_CHANNEL1_PIN);
	md_gpio_set_pin_function(TIMER0_CHANNEL_PORT, TIMER0_CHANNEL1_PIN, MD_GPIO_FUNC_2);
}

/**
  * @brief  Initialize TIMER.
  * @param  None
  * @retval None
  */
void pwm_config(TIMER_TypeDef *tim, uint32_t period, uint16_t duty)
{
	/* up count mode */
	md_timer_set_counter_direction_dirsel(tim, 1);
	/* set prescaler */
	md_timer_set_prescaler_value_pscv(tim, 0X17);
	/* auto reload value */
	md_timer_set_auto_reload_value_arrv(tim, period);
	/* Internal clock source */
	md_timer_set_slave_mode_smods(tim, 0);
	/* PWM1 mode */
	md_timer_set_output_compare1_mode_ch1omod(tim, 0x06);
	/* OC1 active high */
	md_timer_set_cc1_output_polarity_cc1pol(tim, 0);
	/* set duty */
	md_timer_set_capture_compare1_value_ccrv1(tim, duty);
	/* chanel1 output enable */
	md_timer_set_cc1_output_enable_cc1en(tim, 0x01);
	/* enable timer */
	md_timer_enable_counter_cnten(tim);
	/* main output enable */
	md_timer_set_main_output_enable(tim, 0x01);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
        md_init_1ms_tick();
	md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC_3, MD_CMU_PLL_OUTPUT_48M);
	md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
        
	gpio_init();
	/* Initialize timer */
	pwm_config(AD16C4T0, 1000, 500);
	
	while(1);
}

/**
  * @}
  */
/**
  * @}
  */

