/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for demo
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */

/**
  * @brief  Initializate buf of spi communication.
  */
uint8_t tx_buf[32];

/**
  * @brief  spi_handle_t structure.
  */
md_spi_init_t h_spi;

/**
  * @brief  Initializate pin of spi module.
  * @retval None
  */
void spi_pin_init(void)
{
	md_gpio_init_t x;

	/* Initialize sck pin */
	x.mode = MD_GPIO_MODE_OUTPUT;
	x.odos = MD_GPIO_PUSH_PULL;
	x.pupd = MD_GPIO_PUSH_UP;
	x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
	x.flt  = MD_GPIO_FILTER_DISABLE;
	x.type = MD_GPIO_TYPE_TTL;
	x.func = MD_GPIO_FUNC_6;
	md_gpio_init(GPIO_PORT, SPI_SCK_PIN, &x);

	/* Initialize miso pin */
	x.mode = MD_GPIO_MODE_INPUT;
	x.odos = MD_GPIO_PUSH_PULL;
	x.pupd = MD_GPIO_PUSH_UP;
	x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
	x.flt  = MD_GPIO_FILTER_DISABLE;
	x.type = MD_GPIO_TYPE_TTL;
	x.func = MD_GPIO_FUNC_6;
	md_gpio_init(GPIO_PORT, SPI_MISO_PIN, &x);

	/* Initialize mosi pin */
	x.mode = MD_GPIO_MODE_OUTPUT;
	x.odos = MD_GPIO_PUSH_PULL;
	x.pupd = MD_GPIO_PUSH_UP;
	x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
	x.flt  = MD_GPIO_FILTER_DISABLE;
	x.type = MD_GPIO_TYPE_TTL;
	x.func = MD_GPIO_FUNC_6;
	md_gpio_init(GPIO_PORT, SPI_MOSI_PIN, &x);

	/* Initialize cs pin */
	x.mode = MD_GPIO_MODE_OUTPUT;
	x.odos = MD_GPIO_PUSH_PULL;
	x.pupd = MD_GPIO_PUSH_UP;
	x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
	x.flt  = MD_GPIO_FILTER_DISABLE;
	x.type = MD_GPIO_TYPE_TTL;
	x.func = MD_GPIO_FUNC_1;
	md_gpio_init(GPIO_PORT, SPI_NSS_PIN, &x);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize 1ms tick */
	md_init_1ms_tick();
	/* clear spi_handle_t structure */
	memset(&h_spi, 0x0, sizeof(h_spi));
	/* clear tx buffer */
	memset(tx_buf, 0x55, 32);
	
	spi_pin_init();

	/* Initialize SPI0 */
	md_spi_struct_init(&h_spi);
	md_spi_init(SPI0, &h_spi);

	/* transmit 1 byte data by master mode */
	md_spi_set_data_reg(SPI0, tx_buf[0]);

	while (1) {		
		md_delay_1ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
