/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	md_rtc_init_t rtc_init;
	md_rtc_time_t rtc_time;
	md_rtc_date_t rtc_date;

	md_init_1ms_tick();
	
	NVIC_SetPriority(RTC_TSENSE_IRQn, 3);
	NVIC_EnableIRQ(RTC_TSENSE_IRQn);
	
	rtc_init.asynch_pre_div   = 0;
	rtc_init.synch_pre_div    = 32767;
	rtc_init.hour_format      = MD_RTC_HOUR_FORMAT_24;
	rtc_init.output           = MD_RTC_ALARMOUT_DISABLE;
	rtc_init.output_polarity  = MD_RTC_OUTPUT_POLARITY_HIGH;
	md_rtc_init(&rtc_init);
	
	rtc_time.hour   = 21;
	rtc_time.minute = 22;
	rtc_time.second = 43;
	rtc_date.day    = 11;
	rtc_date.month  = 9;
	rtc_date.year   = 17;
	rtc_date.week   = 1;
	
	md_rtc_set_time(&rtc_time, MD_RTC_FORMAT_DEC);
	md_rtc_set_date(&rtc_date, MD_RTC_FORMAT_DEC);
	
	md_rtc_set_wakeup_clock(MD_RTC_WAKEUP_CLOCK_DIV_2);
	md_rtc_wakeup_set_reload((32768 >> 2) - 1);
	md_rtc_enable_wute();
	
	md_rtc_enable_wu_intrrupt();
	
	while(1) {
		md_pmu_stop1_enter();
	}
}

/**
  * @}
  */
/**
  * @}
  */

