/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
uint8_t flag = 0;

void pin_init(void)
{
	md_gpio_init_t x;

	/* Initialize PA0_WKUP-TAMPER1_RTC #0 pin */
	x.mode = MD_GPIO_MODE_INPUT;
        x.odos = MD_GPIO_OPEN_SOURCE;
        x.pupd = MD_GPIO_PUSH_UP;
        x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
	x.flt  = MD_GPIO_FILTER_DISABLE;
	x.type = MD_GPIO_TYPE_TTL;
	x.func = MD_GPIO_FUNC_1;

	md_gpio_init(RTC_WKUP_PORT, RTC_WKUP_PIN, &x);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	md_rtc_init_t rtc_init;
	md_rtc_time_t rtc_time;
	md_rtc_date_t rtc_date;
	md_rtc_tamper_t rtc_tamper;

	md_init_1ms_tick();
	
	NVIC_SetPriority(RTC_TSENSE_IRQn, 3);
	NVIC_EnableIRQ(RTC_TSENSE_IRQn);
	
	pin_init();
	
	rtc_init.asynch_pre_div   = 0;
	rtc_init.synch_pre_div    = 32767;
	rtc_init.hour_format      = MD_RTC_HOUR_FORMAT_24;
	rtc_init.output           = MD_RTC_ALARMOUT_DISABLE;
	rtc_init.output_polarity  = MD_RTC_OUTPUT_POLARITY_HIGH;
	md_rtc_init(&rtc_init);
	
	rtc_time.hour   = 21;
	rtc_time.minute = 22;
	rtc_time.second = 43;
	rtc_date.day    = 11;
	rtc_date.month  = 9;
	rtc_date.year   = 17;
	rtc_date.week   = 1;
	
	md_rtc_set_time(&rtc_time, MD_RTC_FORMAT_DEC);
	md_rtc_set_date(&rtc_date, MD_RTC_FORMAT_DEC);
	
	rtc_tamper.idx  = MD_RTC_TAMPER_1;
	rtc_tamper.trig = MD_RTC_TAMPER_TRIGGER_LOW;
	rtc_tamper.freq = MD_RTC_TAMPER_SAMPLING_FREQ_256;
	rtc_tamper.dur  = MD_RTC_TAMPER_DURATION_1;
	rtc_tamper.ts   = ENABLE;
	md_rtc_set_tamper(&rtc_tamper);
	
	md_rtc_set_time_stamp(MD_RTC_TS_SIGNAL_SEL_TAMPER1, MD_RTC_TS_FALLING_EDGE);
	
	md_rtc_enable_ts_intrrupt();
	
	while(1) {
		md_delay_1ms(10);
	}
}

/**
  * @}
  */
/**
  * @}
  */

