/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 


#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  This function configures GPIO
  * @param  None
  * @retval None
  */
void config_gpio(void)
{
	md_gpio_set_pin_function(LED2_GPIO_PORT, LED2_GPIO_PIN, MD_GPIO_FUNC_1);
	md_gpio_set_pin_push_pull(LED2_GPIO_PORT, LED2_GPIO_PIN);
	md_gpio_set_pin_mode_output(LED2_GPIO_PORT, LED2_GPIO_PIN);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	md_init_1ms_tick();
	config_gpio();
	
	while (1) {
		md_delay_1ms(100);
		md_gpio_toggle_pin_output(LED2_GPIO_PORT, LED2_GPIO_PIN);
	}
}

/**
  * @}
  */
/**
  * @}
  */
