/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 


#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	md_init_1ms_tick();
	
	NVIC_SetPriority(EXTI0_3_IRQn, 3);
	NVIC_EnableIRQ(EXTI0_3_IRQn);
	
	/* Config gpio */
	md_gpio_set_pin_mode_input(GPIO_EXTI_PORT, GPIO_EXTI_PIN);
	md_gpio_set_pin_drive_normal(GPIO_EXTI_PORT, GPIO_EXTI_PIN);
	md_gpio_set_pin_push_up(GPIO_EXTI_PORT, GPIO_EXTI_PIN);
	md_gpio_set_pin_function(GPIO_EXTI_PORT, GPIO_EXTI_PIN, MD_GPIO_FUNC_1);
	/* Configure filter */
	md_gpio_interrupt_filter_enable(GPIO_EXTI_PIN);
	md_giop_interrupt_filter_clock_select(0);
	md_giop_interrupt_filter_time_set(10);
	md_gpio_enable_trailing_edge_trigger(GPIO_EXTI_PIN);
	/* Enable external interrupt */
	md_gpio_set_interrupt_port(GPIO_EXTI_PORT, GPIO_EXTI_PIN);
	md_gpio_clear_flag(GPIO_EXTI_PIN);
	md_gpio_enable_external_interrupt(GPIO_EXTI_PIN);
	while (1) {
		md_delay_1ms(100);
	}
}

/**
  * @}
  */
/**
  * @}
  */
