/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for demo
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief write buffer
  */
uint32_t write[8] = {0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344};

/**
  * @brief read buffer
  */
uint32_t read[8] = {0};

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize 1ms tick */
	md_init_1ms_tick();

	/* Erase flash */
	md_flash_page_erase(20 * 1024);

	/* Write data to flash */
	md_flash_word_program(20 * 1024, write, 8);

	/* Read data from the flash address write */
	md_flash_read(read, 20 * 1024, 8);

	/* Erase flash */
	md_flash_page_erase(20 * 1024);

	/* Read data from the flash address write */
	md_flash_read(read, 20 * 1024, 8);

	/*  */
	while (1) {
		md_delay_1ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
