/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
md_dma_descriptor_t dma0_ctrl_base[28] __attribute__ ((aligned(512)));
md_dma_config_t config;
uint8_t src[64];
uint8_t dst[64];
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize 1ms tick */
	md_init_1ms_tick();
	memset(dma0_ctrl_base, 0x0, sizeof(dma0_ctrl_base));
	memset(&config, 0x0, sizeof(md_dma_config_t));
	memset(src, 0x55, 64);
	memset(dst, 0x11, 64);
	md_dma_set_ctrlbase((uint32_t)&dma0_ctrl_base);
	md_dma_enable();
	md_dma_config_struct(&config);

	config.channel = 0;
	config.dst     = dst;
	config.src     = src;
	config.size    = 64;
	
	md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_AUTO, &config);
	md_dma_enable_channel(MD_DMA_CH_0);
	md_dma_enable_soft_req(MD_DMA_CH_0);
	
	while (!(md_dma_is_active_flag_done(MD_DMA_CH_0)));
	
	while (1) {
		md_delay_1ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
