/**
  *********************************************************************************
  *
  * @file    md_conf.h
  * @brief   Enable/Disable the peripheral module.
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */


#ifndef __MD_CONF_H__
#define __MD_CONF_H__

/* Includes ------------------------------------------------------------------ */
#define MD_DMA
#define MD_GPIO
#define MD_UART
#define MD_USART
#define MD_I2C
#define MD_CMU
#define MD_WWDT
#define MD_IWDT
#define MD_RTC
#define MD_FLASH
#define MD_ADC
#define MD_CRC
#define MD_CRYPT
#define MD_TIM
#define MD_SPI
#define MD_TRNG
#define MD_SYSCFG

#ifdef MD_DMA
	#include "md_dma.h"
#endif	/* MD_DMA */

#ifdef MD_GPIO
	#include "md_gpio.h"
#endif	/*MD_GPIO */

#ifdef MD_UART
	#include "md_uart.h"
#endif	/* MD_UART */

#ifdef MD_USART
	#include "md_usart.h"
#endif	/* MD_USART */

#ifdef MD_I2C
	#include "md_i2c.h"
#endif	/* MD_I2C */

#ifdef MD_CMU
	#include "md_cmu.h"
#endif	/* MD_CMU */

#ifdef MD_WWDT
	#include "md_wwdt.h"
#endif	/* MD_WWDT */

#ifdef MD_IWDT
	#include "md_iwdt.h"
#endif	/* MD_IWDT */

#ifdef MD_RTC
	#include "md_rtc.h"
#endif	/* MD_RTC */

#ifdef MD_FLASH
	#include "md_flash.h"
#endif	/*MD_FLASH*/

#ifdef MD_ADC
	#include "md_adc.h"
#endif	/* MD_ADC */

#ifdef MD_CRC
	#include "md_crc.h"
#endif	/* MD_CRC */

#ifdef MD_CRYPT
	#include "md_crypt.h"
#endif	/* MD_CRYPT */

#ifdef MD_TIM
	#include "md_tim.h"
#endif	/* MD_TIM */

#ifdef MD_SPI
	#include "md_spi.h"
#endif	/* MD_SPI */

#ifdef MD_TRNG
	#include "md_trng.h"
#endif	/* MD_TRNG */

#ifdef MD_SYSCFG
	#include "md_syscfg.h"
#endif	/* MD_SYSCFG */

#endif
