/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */



spi_handle_t h_spi;
md_spi_init_t init;
uint8_t tx_buf[32];
uint8_t rx_buf[32];

/**
  * @brief  Initializate pin of spi module.
  * @retval None
  */
void spi_pin_init(void)
{
	gpio_init_t x;

	/* Initialize sck pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_6;
	ald_gpio_init(GPIO_PORT, SPI_SCK_PIN, &x);

	/* Initialize miso pin */
	x.mode = GPIO_MODE_INPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_6;
	ald_gpio_init(GPIO_PORT, SPI_MISO_PIN, &x);

	/* Initialize mosi pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_6;
	ald_gpio_init(GPIO_PORT, SPI_MOSI_PIN, &x);

	/* Initialize cs pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIO_PORT, SPI_NSS_PIN, &x);

	return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_send_complete(spi_handle_t *arg)
{
	return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_recv_complete(spi_handle_t *arg)
{
	return;
}

/**
  * @brief  Send and receive a message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_send_recv_complete(spi_handle_t *arg)
{
	return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_error(spi_handle_t *arg)
{
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	/* clear spi_handle_t structure */
	memset(&h_spi, 0x0, sizeof(h_spi));
	/* clear rx buffer */
	memset(rx_buf, 0x55, 32);
	/* Initialize pin */
	spi_pin_init();
	/* Initialize tx_buf */
	memset(tx_buf, 0x55, 32);

	/* Initialize SPI */
	h_spi.perh           = SPI0;
	h_spi.init.mode      = SPI_MODE_MASTER;
	h_spi.init.dir       = SPI_DIRECTION_2LINES;
	h_spi.init.data_size = SPI_DATA_SIZE_8;
	h_spi.init.baud      = SPI_BAUD_16;
	h_spi.init.phase     = SPI_CPHA_SECOND;
	h_spi.init.polarity  = SPI_CPOL_HIGH;
	h_spi.init.first_bit = SPI_FIRSTBIT_MSB;
	h_spi.init.ss_en     = DISABLE;
	h_spi.init.crc_calc  = DISABLE;
	h_spi.init.crc_poly  = 0;
	h_spi.tx_cplt_cbk    = spi_send_complete;
	h_spi.rx_cplt_cbk    = spi_recv_complete;
	h_spi.tx_rx_cplt_cbk = spi_send_recv_complete;
	h_spi.err_cbk        = spi_error;
	
	
	init.mode       = MD_SPI_MODE_MASTER;
	init.dir        = MD_SPI_DIRECTION_2LINES;
	init.data_size	= MD_SPI_DATA_SIZE_8;
	init.baud       = MD_SPI_BAUD_16;
	init.phase      = MD_SPI_CPHA_SECOND;
	init.polarity   = MD_SPI_CPOL_HIGH;
	init.first_bit  = MD_SPI_FIRSTBIT_MSB;
	init.ss_en      = DISABLE;
	init.crc_calc   = DISABLE;
	init.crc_poly   = 0;
	md_spi_init(h_spi.perh, &init);

	/* Send a message */
	h_spi.state = SPI_STATE_READY;
	ald_gpio_write_pin(GPIO_PORT, SPI_NSS_PIN, 0);
	ald_spi_send(&h_spi, tx_buf, 5, 1000);
	ald_gpio_write_pin(GPIO_PORT, SPI_NSS_PIN, 1);
	/* Receive a message */
	h_spi.state = SPI_STATE_READY;
	ald_gpio_write_pin(GPIO_PORT, SPI_NSS_PIN, 0);
	ald_spi_recv(&h_spi, rx_buf, 5, 10000);
	ald_gpio_write_pin(GPIO_PORT, SPI_NSS_PIN, 1);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
