/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"
#include <string.h>

#define USART0_TX_PORT	GPIOB
#define USART0_TX_PIN	GPIO_PIN_6
#define USART0_RX_PORT	GPIOB
#define USART0_RX_PIN	GPIO_PIN_7

#define BUFFER_SIZE 200

extern usart_handle_t h_usart;

#define USR_ADC_COUNT	20
#define USR_ADC_CH_NR	4


/* IO pin definition */
#define GPIO_CH0_PORT  	GPIOC
#define ADC_CH0_PIN  	GPIO_PIN_0

#define GPIO_CH1_PORT  	GPIOC
#define ADC_CH1_PIN  	GPIO_PIN_1

#define GPIO_CH2_PORT  	GPIOC
#define ADC_CH2_PIN  	GPIO_PIN_2

#define GPIO_CH3_PORT  	GPIOC
#define ADC_CH3_PIN  	GPIO_PIN_3

#define GPIO_CH4_PORT  	GPIOA
#define ADC_CH4_PIN  	GPIO_PIN_0

#define GPIO_CH5_PORT  	GPIOA
#define ADC_CH5_PIN  	GPIO_PIN_1

#define GPIO_CH6_PORT  	GPIOA
#define ADC_CH6_PIN  	GPIO_PIN_2

#define GPIO_CH7_PORT  	GPIOA
#define ADC_CH7_PIN  	GPIO_PIN_3

#define GPIO_CH8_PORT  	GPIOA
#define ADC_CH8_PIN  	GPIO_PIN_4

#define GPIO_CH9_PORT  	GPIOA
#define ADC_CH9_PIN  	GPIO_PIN_5

#define GPIO_CH10_PORT  GPIOA
#define ADC_CH10_PIN  	GPIO_PIN_6

#define GPIO_CH11_PORT  GPIOA
#define ADC_CH11_PIN  	GPIO_PIN_7

#define GPIO_CH12_PORT  GPIOC
#define ADC_CH12_PIN  	GPIO_PIN_4

#define GPIO_CH13_PORT  GPIOC
#define ADC_CH13_PIN  	GPIO_PIN_5


#endif
