/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
uint16_t result;
float temp;
uint8_t flag = 1;

/**
  * @brief  Callback function
  * @param  value: The value of temperature.
  * @param  status: The status: OK/ERROR.
  * @retval None
  */
void temp_callback(uint16_t value, ald_status_t status)
{
	if (status == OK) {
		/* Get the current temperature value */
		result = value;
		/* Get the temperature in degrees Celsius. */
		temp = result / 256.0;
	}

	flag = 1;
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	/* APB2 bus divide by 2 */
	ald_cmu_div_config(CMU_PCLK_2, CMU_DIV_2);

	/* Enable CRC mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Enable TSENSE interrupt */
	ald_mcu_irq_config(RTC_TSENSE_IRQn, 1, ENABLE);

	/* Initialize tsense */
	ald_tsense_source_select(TSENSE_SOURCE_LOSC);
	ald_tsense_init();
	flag = 0;

	/* Get the current temperature by interrupt */
	ald_tsense_get_value_by_it(temp_callback);

	while (1) {
		ald_delay_ms(2000);
		
		if (flag) {
			flag = 0;
			ald_tsense_get_value_by_it(temp_callback);
		}	
	}
}

/**
  * @}
  */
/**
  * @}
  */
