/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

trng_handle_t h_trng;

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	volatile uint32_t ret;

	/* Initialize ALD */
	ald_cmu_init();
	/* Reset the h_trng */
	memset(&h_trng, 0x0, sizeof(trng_handle_t));

	/* Initialize trng */
	h_trng.perh            = TRNG; 
	h_trng.init.data_width = TRNG_DSEL_32B;
	h_trng.init.seed_type  = TRNG_SEED_TYPE_SEED;
	h_trng.init.seed       = 12345678;
	h_trng.init.t_start    = 7;
	h_trng.init.adjc       = 0;
	h_trng.init.posten     = DISABLE;
	ald_trng_init(&h_trng);

	/* Start calculating random */
	TRNG_ENABLE();

	/* Waiting flag */
	while (!(ald_trng_get_flag_status(&h_trng, TRNG_IF_DAVLD)));

	/* Get the result */
	ret = ald_trng_get_result(&h_trng);
	UNUSED(ret);

	while (1) {
		ald_delay_ms(1000);
	}
	
}

/**
  * @}
  */
/**
  * @}
  */
