/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
	
uint32_t delay;
timer_handle_t h_tim;
timer_clock_config_t tim_clock;
timer_one_pulse_init_t tim_onepulse;

uint32_t uhPrescalerValue = 0;
/**
  * @brief  Initializate pin of tim module.
  * @retval None
  */
void tim_pin_init(void)
{
	gpio_init_t GPIO_InitStructure;
	
	/* Initialize tim0 ch1 pin */
	GPIO_InitStructure.mode = GPIO_MODE_OUTPUT;
	GPIO_InitStructure.odos = GPIO_PUSH_PULL;
	GPIO_InitStructure.pupd = GPIO_PUSH_UP;
	GPIO_InitStructure.odrv = GPIO_OUT_DRIVE_NORMAL;
	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
	GPIO_InitStructure.type = GPIO_TYPE_TTL;
	GPIO_InitStructure.func = GPIO_FUNC_2;
    
        //CH1
	ald_gpio_init(TIMER0_PULSE_PORT, TIMER0_PULSE_PIN, &GPIO_InitStructure);
 
        GPIO_InitStructure.mode = GPIO_MODE_INPUT;
	GPIO_InitStructure.pupd = GPIO_PUSH_DOWN;
	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
	GPIO_InitStructure.type = GPIO_TYPE_TTL;
	GPIO_InitStructure.func = GPIO_FUNC_2;
        //CH2
        ald_gpio_init(TIMER0_TRIGGER_PORT, TIMER0_TRIGGER_PIN, &GPIO_InitStructure);
}


/**
  * @brief  Main function
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
        ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1,48000000);
    
        /* Compute the prescaler value to have TIMER0 counter clock equal to 2000000 Hz */
        uhPrescalerValue = (uint32_t)((ald_cmu_get_pclk1_clock()) / 2000000) - 1;
    
	/* Initialize pin and set default state */
	tim_pin_init();

	/* Initialize AD16C4T0 */
	h_tim.perh           = AD16C4T0;
	h_tim.init.prescaler = 0;
	h_tim.init.mode      = TIMER_CNT_MODE_UP;
	h_tim.init.period    = 65535;
	h_tim.init.clk_div   = TIMER_CLOCK_DIV1;
	h_tim.init.re_cnt    = 0;
	ald_timer_one_pulse_init(&h_tim,TIMER_OP_MODE_REPEAT);

	/* Initialize clock source */
	tim_clock.source = TIMER_SRC_INTER;
	ald_timer_config_clock_source(&h_tim, &tim_clock);

	/* Config one pulse channel */
	tim_onepulse.mode        = TIMER_OC_MODE_PWM2;
	tim_onepulse.pulse       = 16383;
	tim_onepulse.oc_polarity = TIMER_OC_POLARITY_HIGH;
	tim_onepulse.polarity    = TIMER_IC_POLARITY_RISE;
	tim_onepulse.sel         = TIMER_IC_SEL_DIRECT;
	tim_onepulse.filter      = 0;
	ald_timer_one_pulse_config_channel(&h_tim, &tim_onepulse, TIMER_CHANNEL_1, TIMER_CHANNEL_2);

	/* start one pulse */
	ald_timer_one_pulse_start(&h_tim, TIMER_OP_OUTPUT_CHANNEL_1);

	/* Stop one pulse */
	while(1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
