/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
	
uint32_t value[2] = {0};
uint32_t delay = 0;
timer_handle_t h_tim;
timer_clock_config_t tim_clock;
timer_oc_init_t tim_ocinit;

/* Counter Prescaler value */
uint32_t __psc;

#define  PERIOD_VALUE	(uint32_t)(700 - 1)  			/* Period Value  */
#define  PULSE1_VALUE	(uint32_t)(PERIOD_VALUE / 2)		/* Capture Compare 1 Value  */
#define  PULSE2_VALUE	(uint32_t)(PERIOD_VALUE * 37.5 / 100)	/* Capture Compare 2 Value  */
#define  PULSE3_VALUE	(uint32_t)(PERIOD_VALUE / 4)		/* Capture Compare 3 Value  */
#define  PULSE4_VALUE	(uint32_t)(PERIOD_VALUE * 12.5 / 100)	/* Capture Compare 4 Value  */

/**
  * @brief  Initializate pin of tim module.
  * @retval None
  */
void tim_pin_init(void)
{
	gpio_init_t x;
	
	/* Initialize tim0 ch1 pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_2;

	ald_gpio_init(TIMER0_CHANNEL_PORT, TIMER0_CHANNEL1_PIN, &x);
        ald_gpio_init(TIMER0_CHANNEL_PORT, TIMER0_CHANNEL2_PIN, &x);
        ald_gpio_init(TIMER0_CHANNEL_PORT, TIMER0_CHANNEL3_PIN, &x);
        ald_gpio_init(TIMER0_CHANNEL_PORT, TIMER0_CHANNEL4_PIN, &x);
}

/**
  * @brief  This is main function
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
        /* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1,48000000);
    
        /* Compute the prescaler value to have TIM0 counter clock equal to 2000000 Hz */
        __psc = (uint32_t)((ald_cmu_get_pclk1_clock()) / 2000000) - 1;

	/* Initialize AD16C4T0 */
	h_tim.perh           = AD16C4T0;
	h_tim.init.prescaler = __psc;
	h_tim.init.mode      = TIMER_CNT_MODE_UP;
	h_tim.init.period    = PERIOD_VALUE;
	h_tim.init.clk_div   = TIMER_CLOCK_DIV1;
	h_tim.init.re_cnt    = 0;
	ald_timer_pwm_init(&h_tim);

        /* Initialize pin */
	tim_pin_init();

	/* Initialize clock source */
	tim_clock.source = TIMER_SRC_INTER;
	ald_timer_config_clock_source(&h_tim, &tim_clock);

	/* Common configuration for all channels */
	tim_ocinit.oc_mode      = TIMER_OC_MODE_PWM1;
        tim_ocinit.oc_polarity  = TIMER_OC_POLARITY_HIGH;
        tim_ocinit.oc_fast_en   = DISABLE;
        tim_ocinit.ocn_polarity = TIMER_OCN_POLARITY_HIGH;
        tim_ocinit.ocn_idle     = TIMER_OCN_IDLE_RESET;
        tim_ocinit.oc_idle      = TIMER_OC_IDLE_RESET;
    
        /* Set the pulse value for channel 1 */
        tim_ocinit.pulse = PULSE1_VALUE;
	ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_1);
    
        /* Set the pulse value for channel 2 */
        tim_ocinit.pulse = PULSE2_VALUE;
	ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_2);
    
        /* Set the pulse value for channel 3 */
        tim_ocinit.pulse = PULSE3_VALUE;
	ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_3);
    
        /* Set the pulse value for channel 4 */
        tim_ocinit.pulse = PULSE4_VALUE;
	ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_4);

	/* Start input pwm from tim0 channel 1 */
	ald_timer_oc_start(&h_tim, TIMER_CHANNEL_1);
    
        /* Start input pwm from tim0 channel 2 */
	ald_timer_oc_start(&h_tim, TIMER_CHANNEL_2);
    
        /* Start input pwm from tim0 channel 3 */
	ald_timer_oc_start(&h_tim, TIMER_CHANNEL_3);
    
        /* Start input pwm from tim0 channel 4 */
	ald_timer_oc_start(&h_tim, TIMER_CHANNEL_4);
	
	while(1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
