/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"
#include <string.h>


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

pis_handle_t h_pis;
timer_handle_t h_tim1;
timer_handle_t h_tim2;
timer_clock_config_t tim_clock;
timer_oc_init_t tim_ocinit;
timer_master_config_t tim_master_config;
uint8_t buffer[32]   = {0};
uint8_t read_buf[32] = {0};
uint32_t nm_value = 0;

/**
  * @brief  Initializate pin of pis module.
  * @retval None
  */
void pis_pin_init(void)
{
	gpio_init_t x;

	/* Initialize timer0 ch1 pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_2;
	ald_gpio_init(GPIO_TIMER0_CH_PORT, TIMER0_CH1_PIN, &x);

	/* Initialize pis ch0 pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_6;
	ald_gpio_init(GPIO_PIS_CH_PORT, PIS_CH0_PIN, &x);
}

/**
  * @brief  Initializate timer module.
  * @retval None
  */
void pis_tim_init(void)
{
	/* clear timer_handle_t structure */
	memset(&h_tim1,0,sizeof(timer_handle_t));
	/* clear timer_handle_t structure */
	memset(&h_tim2,0,sizeof(timer_handle_t));
	/* clear timer_clock_config_t structure */
	memset(&tim_clock,0,sizeof(timer_clock_config_t));
	/* clear timer_oc_init_t structure */
	memset(&tim_ocinit,0,sizeof(timer_oc_init_t));

	/* Initialize TIMER0 */
	h_tim1.perh           = AD16C4T0;
	h_tim1.init.prescaler = 0xfe;
	h_tim1.init.mode      = TIMER_CNT_MODE_UP;
	h_tim1.init.period    = 0x300;
	h_tim1.init.clk_div   = TIMER_CLOCK_DIV1;
	h_tim1.init.re_cnt    = 5;
	ald_timer_base_init(&h_tim1);

	/* Initialize TIMER2 */
	h_tim2.perh           = GP16C2T0;
	h_tim2.init.prescaler = 0xfe;
	h_tim2.init.mode      = TIMER_CNT_MODE_UP;
	h_tim2.init.period    = 0x300;
	h_tim2.init.clk_div   = TIMER_CLOCK_DIV1;
	h_tim2.init.re_cnt    = 0;
	ald_timer_base_init(&h_tim2);

	/* Initialize clock source */
	tim_clock.source   = TIMER_SRC_ITR0;
	tim_clock.psc      = TIMER_ETR_PSC_DIV1;
	tim_clock.filter   = 0;
	tim_clock.polarity = TIMER_CLK_POLARITY_RISE;
	ald_timer_config_clock_source(&h_tim2, &tim_clock);
}

/**
  * @brief  Start timer0 and timer2 module.
  * @retval None
  */
void pis_tim_start(void)
{
	ald_timer_base_start(&h_tim1);
	ald_timer_base_start(&h_tim2);
}

/**
  * @brief  Stop timer1 module.
  * @retval None
  */
void pis_tim_stop(void)
{
	ald_timer_base_stop(&h_tim1);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	volatile uint32_t cmu = 0;
	/* Initialize ALD */
	ald_cmu_init();

	/* Clear pis_handle_t struct */
	memset(&h_pis,0,sizeof(pis_handle_t));

	/* Initialize pin */
	pis_pin_init();
	/* Initialize timer */
	pis_tim_init();

	/* Initialize PIS */
	h_pis.perh               = PIS;
	h_pis.init.producer_src  = PIS_TIMER0_UPDATA;
	h_pis.init.producer_clk  = PIS_CLK_PCLK1;
	h_pis.init.producer_edge = PIS_EDGE_NONE;
	h_pis.init.consumer_trig = PIS_CH4_TIMER2_ITR0; 
	h_pis.init.consumer_clk  = PIS_CLK_PCLK1;
	ald_pis_create(&h_pis);
	pis_tim_start();

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */

/**
  * @}
  */
