/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief key exti pin init
  * @retval None
  */
void key_pin_init(void)
{
	gpio_init_t x;
	exti_init_t exti;

	/* Initialize key exti pin as input */
	x.mode = GPIO_MODE_INPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_CMOS;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIO_KEY_1_PORT, GPIO_KEY_1_PIN, &x);
	ald_gpio_init(GPIO_KEY_2_PORT, GPIO_KEY_2_PIN, &x);	

	/* Initialize external interrupt */
	exti.filter      = ENABLE;
	exti.cks         = EXTI_FILTER_CLOCK_10K;
	exti.filter_time = 10;
	ald_gpio_exti_init(GPIO_KEY_1_PORT, GPIO_KEY_1_PIN, &exti);
	ald_gpio_exti_init(GPIO_KEY_2_PORT, GPIO_KEY_2_PIN, &exti);

	/* Clear interrupt flag */
	ald_gpio_exti_clear_flag_status(GPIO_KEY_1_PIN);
	ald_gpio_exti_clear_flag_status(GPIO_KEY_2_PIN);

	/* Configure interrupt */
	ald_gpio_exti_interrupt_config(GPIO_KEY_1_PIN, EXTI_TRIGGER_TRAILING_EDGE, ENABLE);	
	ald_gpio_exti_interrupt_config(GPIO_KEY_2_PIN, EXTI_TRIGGER_TRAILING_EDGE, ENABLE);	
}

/**
  * @}
  */

/**
  * @brief led pin init
  * @retval None
  */
void led_pin_init(void)
{
	gpio_init_t x;

	/* Initialize GPIO_PIN_1 as input */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;

	ald_gpio_init(GPIO_LED_1_PORT, GPIO_LED_1_PIN, &x);
	ald_gpio_init(GPIO_LED_2_PORT, GPIO_LED_2_PIN, &x);		
}
/**
  * @}
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{


	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	/* Enable external interrupt */
	ald_mcu_irq_config(EXTI0_3_IRQn, 3, ENABLE);

	key_pin_init();
	led_pin_init();

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @brief  GPIO IRQ handler
  * @retval None
  */
void gpio_irq_handler(void)
{
	/* Check and clear interrupt flag */
	if (ald_gpio_exti_get_flag_status(GPIO_KEY_1_PIN)) {
		ald_gpio_exti_clear_flag_status(GPIO_KEY_1_PIN);
		ald_gpio_toggle_pin(GPIO_LED_1_PORT, GPIO_LED_1_PIN);
	}

	if (ald_gpio_exti_get_flag_status(GPIO_KEY_2_PIN)) {
		ald_gpio_exti_clear_flag_status(GPIO_KEY_2_PIN);
		ald_gpio_toggle_pin(GPIO_LED_2_PORT, GPIO_LED_2_PIN);
	}

	
	return;
}

/**
  * @}
  */
/**
  * @}
  */
