/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  *********************************************************************************
  */ 

#include "main.h"
#include "utils.h"
#include <stdlib.h>
#include <string.h>

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_I2C
  * @{
  */

i2c_handle_t h_i2c;
uint8_t buffer[10] = {0};
uint8_t read[10] = {0};

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void i2c_pin_init(void)
{
	gpio_init_t a;
	
	/* Initialize scl pin */
	a.mode = GPIO_MODE_OUTPUT;
	a.odos = GPIO_PUSH_PULL;
	a.pupd = GPIO_PUSH_UP;
	a.odrv = GPIO_OUT_DRIVE_NORMAL;
	a.flt  = GPIO_FILTER_DISABLE;
	a.type = GPIO_TYPE_CMOS;
	a.func = GPIO_FUNC_5;
	ald_gpio_init(I2C1_SCL_PORT, I2C1_SCL_PIN, &a);

	/* Initialize sda pin */
	a.mode = GPIO_MODE_OUTPUT;
	a.odos = GPIO_PUSH_PULL;
	a.pupd = GPIO_PUSH_UP;
	a.odrv = GPIO_OUT_DRIVE_NORMAL;
	a.flt  = GPIO_FILTER_DISABLE;
	a.type = GPIO_TYPE_CMOS;
	a.func = GPIO_FUNC_5;
	ald_gpio_init(I2C1_SDA_PORT, I2C1_SDA_PIN, &a);
}

/**
  * @brief  Master send message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void master_tx_complete(i2c_handle_t *arg)
{
	return;
}

/**
  * @brief  Master receive message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void master_rx_complete(i2c_handle_t *arg)
{
	return;
}

/**
  * @brief  Slave send message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void slave_tx_complete(i2c_handle_t *arg)
{
	return;
}

/**
  * @brief  Slave receive message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void slave_rx_complete(i2c_handle_t *arg)
{
	return;
}

/**
  * @brief  Send to Memory complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void memory_tx_complete(i2c_handle_t *arg)
{
	return;
}

/**
  * @brief Read from Memory completed.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void memory_rx_complete(i2c_handle_t *arg)
{
	return;
}

/**
  * @brief  This is main function
  * @retval Status
  */
int main()
{	
	/* Initialize ALD */
	ald_cmu_init();

	/* clear i2c_handle_t structure */
	memset(&h_i2c, 0, sizeof(i2c_handle_t));
	/* Initialize tx_buf */
	memset(buffer, 0x57, 10);
	/* Initialize pin */
	i2c_pin_init();

	/* Initialize I2C */
	h_i2c.perh              = I2C1;
	h_i2c.init.clk_speed    = 100000;
	h_i2c.init.duty         = I2C_DUTYCYCLE_2;
	h_i2c.init.own_addr1    = 0x0A;
	h_i2c.init.addr_mode    = I2C_ADDR_7BIT;
	h_i2c.init.general_call = I2C_GENERALCALL_DISABLE;
	h_i2c.init.no_stretch   = I2C_NOSTRETCH_ENABLE;
	ald_i2c_reset(&h_i2c);
	ald_i2c_init(&h_i2c);

	/* Send a message to salve device's address is 0xA0 */
	ald_i2c_master_send(&h_i2c, 0xA0, buffer, 1, 5000);

	/* Receive a message from salve device's address is 0xA0 */
	ald_i2c_master_recv(&h_i2c, 0xA0, read, 1, 5000);

	while(1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */

/**
  * @}
  */
