/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	gpio_init_t x;
	uint8_t ret;

	/* Initialize */
	ald_cmu_init();

	/* Initialize GPIO_PIN_1 sa output */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_CMOS;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIO_PORT_OUT, GPIO_PIN_OUT, &x);

	/* Initialize GPIO_PIN_0 as input */
	x.mode = GPIO_MODE_INPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_CMOS;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIO_PORT_IN, GPIO_PIN_IN, &x);

	/* Control output */
	ald_gpio_write_pin(GPIO_PORT_OUT, GPIO_PIN_OUT, 0);
	ald_gpio_write_pin(GPIO_PORT_OUT, GPIO_PIN_OUT, 1);
	ald_gpio_write_pin(GPIO_PORT_OUT, GPIO_PIN_OUT, 0);
	ald_gpio_write_pin(GPIO_PORT_OUT, GPIO_PIN_OUT, 1);

	/* Read input level */
	ret = ald_gpio_read_pin(GPIO_PORT_IN, GPIO_PIN_IN);
	ret = ald_gpio_read_pin(GPIO_PORT_IN, GPIO_PIN_IN);
	UNUSED(ret);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
