/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t src0_buf[16];
uint8_t dst0_buf[16];
uint8_t src1_buf[32];
uint8_t dst1_buf[32];
uint8_t src2_buf[64];
uint8_t dst2_buf[64];
uint32_t src3_buf[10];
uint32_t dst3_buf[10];

dma_descriptor_t __alt_desc[4];

/**
  * @brief  DMA send complete.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_complete(void *arg)
{
	return;
}

/**
  * @brief  Config alternate descriptor for memory scatter-gather.
  * @retval None.
  */
void dma_config_alt_desc()
{
	dma_config_t config;

	/* Configure the first descriptor */
	memset(&config, 0x0, sizeof(dma_config_t));
	config.src        = src0_buf;
	config.dst        = dst0_buf;
	config.size       = 16;
	config.R_power    = DMA_R_POWER_1;
	config.data_width = DMA_DATA_SIZE_BYTE;
	config.src_inc    = DMA_DATA_INC_BYTE;;
	config.dst_inc    = DMA_DATA_INC_BYTE;
	ald_dma_config_sg_alt_desc(&__alt_desc[0], &config, 1);

	/* Configure the second descriptor */
	config.src        = src1_buf;
	config.dst        = dst1_buf;
	config.size       = 32;
	config.R_power    = DMA_R_POWER_1;
	config.data_width = DMA_DATA_SIZE_BYTE;
	config.src_inc    = DMA_DATA_INC_BYTE;;
	config.dst_inc    = DMA_DATA_INC_BYTE;
	ald_dma_config_sg_alt_desc(&__alt_desc[1], &config, 1);

	/* Configure the third descriptor */
	config.src        = src2_buf;
	config.dst        = dst2_buf;
	config.size       = 64;
	config.R_power    = DMA_R_POWER_1;
	config.data_width = DMA_DATA_SIZE_BYTE;
	config.src_inc    = DMA_DATA_INC_BYTE;;
	config.dst_inc    = DMA_DATA_INC_BYTE;
	ald_dma_config_sg_alt_desc(&__alt_desc[2], &config, 1);

	/* Configure the fourth descriptor */
	config.src        = src3_buf;
	config.dst        = dst3_buf;
	config.size       = 10;
	config.R_power    = DMA_R_POWER_1;
	config.data_width = DMA_DATA_SIZE_WORD;
	config.src_inc    = DMA_DATA_INC_WORD;;
	config.dst_inc    = DMA_DATA_INC_WORD;
	ald_dma_config_sg_alt_desc(&__alt_desc[3], &config, 1);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	/* Initialize data */
	memset(src0_buf, 0x22, 16);
	memset(dst0_buf, 0x77, 16);
	memset(src1_buf, 0x33, 32);
	memset(dst1_buf, 0x77, 32);
	memset(src2_buf, 0x44, 64);
	memset(dst2_buf, 0x77, 64);
	memset(src3_buf, 0x55, 40);
	memset(dst3_buf, 0x77, 40);

	/* Configure four alternate descriptors */
	dma_config_alt_desc();
	/* Start DMA in memory scatter-gather mode */
	ald_dma_config_sg_mem(DMA0, __alt_desc, 4, 0, dma_complete);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
