/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t src_buf[32];
uint8_t dst_buf[32];
dma_handle_t hperh;
uint8_t nr = 0x11;

/**
  * @brief  DMA send complete.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_complete(void *arg)
{
	memset(src_buf, ++nr, 32);
	ald_dma_restart_auto(&hperh, NULL, NULL, 32);

	return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_error(void *arg)
{
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	/* Initialize src_buf, dst_buf */
	memset(src_buf, 0x22, 32);
	memset(dst_buf, 0x77, 32);

	hperh.perh = DMA0;
	ald_dma_config_struct(&hperh.config);
	hperh.config.channel = 0;
	hperh.config.dst     = dst_buf;
	hperh.config.src     = src_buf;
	hperh.config.size    = 32;
	hperh.cplt_cbk       = dma_complete;
	hperh.cplt_arg       = NULL;
	hperh.err_cbk        = dma_error;
	hperh.err_arg        = NULL;
	ald_dma_config_auto(&hperh);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
