/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"
#include "utils.h"
#include "ald_gpio.h"
#include "ald_cmu.h"
#include "ald_rtc.h"
#include "string.h"
#ifdef ALD_DMA
#include "ald_dma.h"
#endif

extern dma_descriptor_t dma0_ctrl_base[28];
extern uint16_t adcbuf;
extern uint8_t adcflag;
extern timer_handle_t h_tim;

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
	/* Added Emergency operation */
	return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
	/* Added debug information */
	while (1)
		;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
	/* Added system callback */
	return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
	/* Added debug operation */
	return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
	/* Added thread switching operation */
	return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
	ald_inc_tick();
	return;
}

/**
  * @brief  ADC and ACMP IRQ handler
  * @retval None
  */
void ADC_ACMP_Handler(void)
{	
	/* Handle adc interrupt */
	ald_adc_irq_handler(&h_adc);
	return;
}

/**
  * @brief  AD16C4T0 IRQ handler
  * @retval None
  */
void BS16T0_Handler(void)
{
	return;
}


#ifdef ALD_DMA
/**
  * @brief  DMA handler
  * @retval None
  */
void DMA_Handler(void)
{
	ADC0->CON1   &= ~0x01;	/* Stop ADC */
	DMA0->CHENCLR = 1;	/* Disable DMA channel */
	DMA0->ICFR    = 1;	/* Clear DMA flag */
	TIMER_DISABLE(&h_tim);	/* Stop pis trigger */
	adcflag = 1;		/* SET Flag */
}
#endif
/**
  * @}
  */

/**(null)
  * @}
  */
