#include "main.h"

uint16_t adv = 0;
uint16_t bkadv = 0;

int main()
{
	ald_cmu_init();
	
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	
	bsp_InitLed();
	bsp_button_init();
	bsp_bldc_init();
	adc_module_init();
	
	while(1)
	{
		//ٶ
		adv = adc_average();
		if ((adv != bkadv) && (adv > 500))
		{
			bkadv = adv;
			bsp_bldc_set_pwm(adv);
		}
		
		//Ƿѹ
		if (!ald_gpio_read_pin(GPIOD, GPIO_PIN_0))
		{
			bsp_LedToggle(6);
			ald_delay_ms(50);
		}
	}
}

void ald_systick_irq_cbk(void)
{
	static uint8_t cnt = 0;

	if((++cnt % 5) == 0) {
		button_ticks();
	}
}


