/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    07 Nov 2017
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#include "main.h"
#include "utils.h"
#include "ald_cmu.h"
#include "bsp_bldc.h"
#include "ald_timer.h"
#include "ald_gpio.h"
#ifdef ALD_DMA
#include "ald_dma.h"
#endif

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
volatile uint8_t hall_sta = 0;
/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
	/* Added Emergency operation */
	return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
	/* Added debug information */
	while (1)
		;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
	/* Added system callback */
	return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
	/* Added debug operation */
	return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
	/* Added thread switching operation */
	return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
	ald_inc_tick();
	return;
}

/**
  * @brief  CMU IRQ#4 handler
  * @retval None
  */
void CMU_Handler(void)
{
	ald_cmu_irq_handler();
	return;
}

#ifdef ALD_DMA
/**
  * @brief  DMA IRQ#9 handler
  * @retval None
  */
void DMA_Handler(void)
{
	ald_dma_irq_handler();
}
#endif

/**
  * @brief  EXTI IRQ handler
  * @retval None
  */
void EXTI12_15_Handler(void)
{
	static  uint8_t flag = 0;
	
	if (flag == 0) {
		flag = 1;
		GP16C4T0->COUNT = 0;
		ald_timer_base_start(&Tim6Handle); 
	} else {
		ald_timer_base_stop(&Tim6Handle);
		scnt = GP16C4T0->COUNT;
		flag = 0;
	}
	
	if ( (ald_gpio_exti_get_flag_status(GPIO_PIN_12) == SET) | \
	     (ald_gpio_exti_get_flag_status(GPIO_PIN_13) == SET) | \
	     (ald_gpio_exti_get_flag_status(GPIO_PIN_14) == SET)) { 
        	
		ald_gpio_exti_clear_flag_status(GPIO_PIN_12);
        	ald_gpio_exti_clear_flag_status(GPIO_PIN_13);
        	ald_gpio_exti_clear_flag_status(GPIO_PIN_14);
		
	        hall_sta = bsp_bldc_hallsensor_position();
		bsp_bldc_commutation(hall_sta);
	}
}
/**
  * @}
  */

/**
  * @}
  */
