
#include "ald_gpio.h"
#include "bsp_led.h"


#define GPIO_PORT_LED1  GPIOC
#define GPIO_PIN_LED1	GPIO_PIN_9

#define GPIO_PORT_LED2  GPIOA
#define GPIO_PIN_LED2	GPIO_PIN_8

#define GPIO_PORT_LED3  GPIOA
#define GPIO_PIN_LED3	GPIO_PIN_9

#define GPIO_PORT_LED4  GPIOA
#define GPIO_PIN_LED4	GPIO_PIN_10

#define GPIO_PORT_LED5  GPIOA
#define GPIO_PIN_LED5	GPIO_PIN_11

#define GPIO_PORT_LED6  GPIOA
#define GPIO_PIN_LED6	GPIO_PIN_12


GPIO_TypeDef * GPIO_PORT[LEDn] = { GPIO_PORT_LED1,
				   GPIO_PORT_LED2,
				   GPIO_PORT_LED3,
				   GPIO_PORT_LED4,
				   GPIO_PORT_LED5,
				   GPIO_PORT_LED6 };

const uint16_t GPIO_PIN[LEDn] = {  GPIO_PIN_LED1,
				   GPIO_PIN_LED2,
				   GPIO_PIN_LED3,
				   GPIO_PIN_LED4,
				   GPIO_PIN_LED5,
				   GPIO_PIN_LED6 };




/*
*********************************************************************************************************
*	  : bsp_InitLed
*	˵: LEDָʾصGPIO,  ú bsp_Init() á
*	    :  
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_InitLed(void)
{
	uint8_t i = 0;
	gpio_init_t GPIO_InitStructure;;
	for ( i = 0; i < LEDn; ++i) {
		bsp_LedOff(i);
	}
	/* LED1 */
	GPIO_InitStructure.mode = GPIO_MODE_OUTPUT;
	GPIO_InitStructure.odos = GPIO_PUSH_PULL;
	GPIO_InitStructure.pupd = GPIO_PUSH_UP;
	GPIO_InitStructure.odrv = GPIO_OUT_DRIVE_NORMAL;
	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
	GPIO_InitStructure.type = GPIO_TYPE_TTL;
	GPIO_InitStructure.func = GPIO_FUNC_1;
	
	for (i = 0; i < LEDn; ++i) {
		ald_gpio_init(GPIO_PORT[i], GPIO_PIN[i], &GPIO_InitStructure); 
	}
}

/*
*********************************************************************************************************
*	  : bsp_LedOn
*	˵: ָLEDָʾơ
*	    :  _no : ָʾţΧ 1 - 3
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_LedOn(uint8_t _no)
{
	ald_gpio_write_pin(GPIO_PORT[_no - 1], GPIO_PIN[_no - 1], 0);
}

/*
*********************************************************************************************************
*	  : bsp_LedOff
*	˵: ϨָLEDָʾơ
*	    :  _no : ָʾţΧ 1 - 4
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_LedOff(uint8_t _no)
{
	ald_gpio_write_pin(GPIO_PORT[_no - 1], GPIO_PIN[_no - 1],1);
}

/*
*********************************************************************************************************
*	  : bsp_LedToggle
*	˵: תָLEDָʾơ
*	    :  _no : ָʾţΧ 1 - 4
*	  ֵ: 
*********************************************************************************************************
*/
void bsp_LedToggle(uint8_t _no)
{
	ald_gpio_toggle_pin(GPIO_PORT[_no - 1], GPIO_PIN[_no - 1]);
}

