#include "ald_timer.h"
#include "ald_gpio.h"
#include "bsp_bldc.h"


/* Timer handler declaration */
timer_handle_t    Tim0Handle, Tim6Handle;

timer_com_channel_config_t _cfg;

volatile extern uint16_t scnt = 0;

/* Timer Output Compare Configuration Structure declaration */
timer_oc_init_t  sPWMConfig;

/* Timer Break Configuration Structure declaration */
timer_break_dead_time_t sBreakConfig;

#define BLDC_STOP	0
#define BLDC_CW		1
#define BLDC_CCW	2

uint8_t BLDC_MotorSpin = BLDC_CW;

static void BLDC_IoInit(void);

static void BLDC_PWMTimerInit(void);

static void BLDC_speed_timer(void);

uint8_t bsp_bldc_hallsensor_position(void) 
{
	return (uint8_t) ((ald_gpio_read_port(GPIOD) & (GPIO_PIN_12 | GPIO_PIN_13 | GPIO_PIN_14)) >> 12);
}

void bsp_bldc_init(void) 
{
	BLDC_IoInit();
	BLDC_PWMTimerInit();
	bsp_bldc_stop();
	BLDC_speed_timer();
}

static void BLDC_IoInit(void)
{
	gpio_init_t GPIO_InitStructure;
	exti_init_t exti;

	GPIO_InitStructure.mode = GPIO_MODE_OUTPUT;
	GPIO_InitStructure.odos = GPIO_PUSH_PULL;
	GPIO_InitStructure.pupd = GPIO_PUSH_UP;
	GPIO_InitStructure.odrv = GPIO_OUT_DRIVE_STRONG;
	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
	GPIO_InitStructure.type = GPIO_TYPE_TTL;
	GPIO_InitStructure.func = GPIO_FUNC_2;
	
	/* CH1N ---> PE8 & CH1 ---> PE9 */
	ald_gpio_init(GPIOE, GPIO_PIN_8, &GPIO_InitStructure);
	ald_gpio_init(GPIOE, GPIO_PIN_9, &GPIO_InitStructure);
	/* CH2N ---> PE10 & CH2 ---> PE11 */
	ald_gpio_init(GPIOE, GPIO_PIN_10, &GPIO_InitStructure);
	ald_gpio_init(GPIOE, GPIO_PIN_11, &GPIO_InitStructure);
	/* CH3N ---> PE12 & CH3 ---> PE13 */
	ald_gpio_init(GPIOE, GPIO_PIN_12, &GPIO_InitStructure);
	ald_gpio_init(GPIOE, GPIO_PIN_13, &GPIO_InitStructure);
	
	/* GD_EN ---> PD1 */
	GPIO_InitStructure.mode = GPIO_MODE_OUTPUT;
	GPIO_InitStructure.odos = GPIO_PUSH_PULL;
	GPIO_InitStructure.pupd = GPIO_PUSH_UP;
	GPIO_InitStructure.odrv = GPIO_OUT_DRIVE_NORMAL;
	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
	GPIO_InitStructure.type = GPIO_TYPE_TTL;
	GPIO_InitStructure.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOD, GPIO_PIN_1, &GPIO_InitStructure);
	ald_gpio_write_pin(GPIOD, GPIO_PIN_1, 0);
	
	/* Break */
	GPIO_InitStructure.mode = GPIO_MODE_INPUT;
	GPIO_InitStructure.pupd = GPIO_PUSH_DOWN;
	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
	GPIO_InitStructure.type = GPIO_TYPE_TTL;
	GPIO_InitStructure.func = GPIO_FUNC_2;
	ald_gpio_init(GPIOE, GPIO_PIN_15, &GPIO_InitStructure);

	/* Hall ---> PD12PD13PD14 */
	GPIO_InitStructure.mode = GPIO_MODE_INPUT;
	GPIO_InitStructure.pupd = GPIO_FLOATING;
	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
	GPIO_InitStructure.type = GPIO_TYPE_CMOS;
	GPIO_InitStructure.func = GPIO_FUNC_1;
	
	ald_gpio_init(GPIOD, GPIO_PIN_12, &GPIO_InitStructure);
	ald_gpio_init(GPIOD, GPIO_PIN_13, &GPIO_InitStructure);
	ald_gpio_init(GPIOD, GPIO_PIN_14, &GPIO_InitStructure);
	
	/* Initialize external interrupt */
	exti.filter      = DISABLE;
	exti.cks         = EXTI_FILTER_CLOCK_32K;
	exti.filter_time = 1;
	
	ald_gpio_exti_init(GPIOD, GPIO_PIN_12, &exti);
	ald_gpio_exti_clear_flag_status(GPIO_PIN_12);
	ald_gpio_exti_interrupt_config(GPIO_PIN_12, EXTI_TRIGGER_BOTH_EDGE, ENABLE);
	
	ald_gpio_exti_init(GPIOD, GPIO_PIN_13, &exti);
	ald_gpio_exti_clear_flag_status(GPIO_PIN_13);
	ald_gpio_exti_interrupt_config(GPIO_PIN_13, EXTI_TRIGGER_BOTH_EDGE, ENABLE);
	
	ald_gpio_exti_init(GPIOD, GPIO_PIN_14, &exti);
	ald_gpio_exti_clear_flag_status(GPIO_PIN_14);
	ald_gpio_exti_interrupt_config(GPIO_PIN_14, EXTI_TRIGGER_BOTH_EDGE, ENABLE);
	/* enable exti interrupt */
	ald_mcu_irq_config(EXTI12_15_IRQn,1, ENABLE); 
	
	/* FAULT ---> PD0 */
	GPIO_InitStructure.mode = GPIO_MODE_INPUT;
	GPIO_InitStructure.pupd = GPIO_PUSH_UP;
	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
	GPIO_InitStructure.type = GPIO_TYPE_TTL;
	GPIO_InitStructure.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOD, GPIO_PIN_0, &GPIO_InitStructure);
	
	/* I_SAM ---> PA1 */
	GPIO_InitStructure.mode = GPIO_MODE_CLOSE;
//	GPIO_InitStructure.pupd = GPIO_PUSH_UP;
//	GPIO_InitStructure.flt  = GPIO_FILTER_DISABLE;
//	GPIO_InitStructure.type = GPIO_TYPE_TTL;
	GPIO_InitStructure.func = GPIO_FUNC_0;
	ald_gpio_init(GPIOA, GPIO_PIN_1, &GPIO_InitStructure);

}

static void BLDC_PWMTimerInit(void)
{
	Tim0Handle.perh = AD16C4T0;
	
	Tim0Handle.init.period		= 3500;			//13.714k
	Tim0Handle.init.prescaler	= 0;
	Tim0Handle.init.clk_div		= TIMER_CLOCK_DIV1;
	Tim0Handle.init.mode		= TIMER_CNT_MODE_UP;
	Tim0Handle.init.re_cnt		= 0;
	
	ald_timer_oc_init(&Tim0Handle);
	
	/* Common configuration for all 6 channels */
	sPWMConfig.oc_mode		= TIMER_OC_MODE_TIMERING;
	sPWMConfig.oc_polarity		= TIMER_OC_POLARITY_LOW;
	sPWMConfig.ocn_polarity		= TIMER_OCN_POLARITY_LOW;
	sPWMConfig.oc_idle		= TIMER_OC_IDLE_SET;
	sPWMConfig.ocn_idle		= TIMER_OCN_IDLE_SET;
	sPWMConfig.oc_fast_en		= DISABLE;
	sPWMConfig.pulse		= 500;
	/* Pulse */
	
	ald_timer_oc_config_channel(&Tim0Handle,&sPWMConfig,TIMER_CHANNEL_1);

	ald_timer_oc_config_channel(&Tim0Handle,&sPWMConfig,TIMER_CHANNEL_2); 
	
	ald_timer_oc_config_channel(&Tim0Handle,&sPWMConfig,TIMER_CHANNEL_3); 

	// Break δ 
	sBreakConfig.off_run		= ENABLE;
	sBreakConfig.off_idle		= ENABLE;
	sBreakConfig.lock_level		= TIMER_LOCK_LEVEL_OFF;
	sBreakConfig.break_state	= ENABLE;
	sBreakConfig.polarity		= TIMER_BREAK_POLARITY_HIGH;
	sBreakConfig.auto_out		= ENABLE;
	sBreakConfig.dead_time		= 1;
	
	ald_timer_break_dead_time_config(&Tim0Handle, &sBreakConfig);
	
	/*--------------------------------------------------------------------------*/
	/* Start channel 1 */
	ald_timer_oc_start(&Tim0Handle,TIMER_CHANNEL_1);
	/* Start channel 1N */
	ald_timer_ocn_start(&Tim0Handle, TIMER_CHANNEL_1);
	/*--------------------------------------------------------------------------*/

  
	/*--------------------------------------------------------------------------*/
	/* Start channel 2 */
	ald_timer_oc_start(&Tim0Handle,TIMER_CHANNEL_2);
	/* Start channel 2N */
	ald_timer_ocn_start(&Tim0Handle, TIMER_CHANNEL_2);
	/*--------------------------------------------------------------------------*/

  
	/*--------------------------------------------------------------------------*/	
	/* Start channel 3 */
	ald_timer_oc_start(&Tim0Handle,TIMER_CHANNEL_3);
	/* Start channel 3N */
	ald_timer_ocn_start(&Tim0Handle, TIMER_CHANNEL_3);
}


void BLDC_speed_timer(void)
{
	Tim6Handle.perh = GP16C4T0;
	Tim6Handle.init.period		= 0xffff;			
	Tim6Handle.init.prescaler	= 4799;			//48Mhz/4800 = 10khz
	Tim6Handle.init.clk_div		= TIMER_CLOCK_DIV1;
	Tim6Handle.init.mode		= TIMER_CNT_MODE_UP;
	Tim6Handle.init.re_cnt		= 0;
	ald_timer_base_init(&Tim6Handle);
}


static void BLDC_MotorCommutation_CW(uint16_t hallpos)
{
	switch (hallpos) {
	case 5:
		_cfg.ch[0].en   = DISABLE;			//
		_cfg.ch[0].n_en = ENABLE;			//A-
		_cfg.ch[0].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[1].en   = ENABLE;			//B+
		_cfg.ch[1].n_en = DISABLE;
		_cfg.ch[1].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[2].en   = DISABLE;
		_cfg.ch[2].n_en = DISABLE;
		_cfg.ch[2].mode = TIMER_OC_MODE_PWM1;
		break;

	case 4:
		_cfg.ch[0].en   = DISABLE;
		_cfg.ch[0].n_en = ENABLE;			//A-
		_cfg.ch[0].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[1].en   = DISABLE;
		_cfg.ch[1].n_en = DISABLE;
		_cfg.ch[1].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[2].en   = ENABLE;			//C+
		_cfg.ch[2].n_en = DISABLE;
		_cfg.ch[2].mode = TIMER_OC_MODE_PWM1;
		break;

	case 6:
		_cfg.ch[0].en   = DISABLE;
		_cfg.ch[0].n_en = DISABLE;
		_cfg.ch[0].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[1].en   = DISABLE;
		_cfg.ch[1].n_en = ENABLE;			//B-
		_cfg.ch[1].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[2].en   = ENABLE;			//C+
		_cfg.ch[2].n_en = DISABLE;
		_cfg.ch[2].mode = TIMER_OC_MODE_PWM1;
		break;

	case 2:
		_cfg.ch[0].en   = ENABLE;			//A+
		_cfg.ch[0].n_en = DISABLE;
		_cfg.ch[0].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[1].en   = DISABLE;
		_cfg.ch[1].n_en = ENABLE;			//B-
		_cfg.ch[1].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[2].en   = DISABLE;
		_cfg.ch[2].n_en = DISABLE;
		_cfg.ch[2].mode = TIMER_OC_MODE_PWM1;
		break;

	case 3:
		_cfg.ch[0].en   = ENABLE;			//A+
		_cfg.ch[0].n_en = DISABLE;
		_cfg.ch[0].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[1].en   = DISABLE;
		_cfg.ch[1].n_en = DISABLE;
		_cfg.ch[1].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[2].en   = DISABLE;
		_cfg.ch[2].n_en = ENABLE;			//C-
		_cfg.ch[2].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		break;

	case 1:
		_cfg.ch[0].en   = DISABLE;
		_cfg.ch[0].n_en = DISABLE;
		_cfg.ch[0].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[1].en   = ENABLE;			//B+
		_cfg.ch[1].n_en = DISABLE;
		_cfg.ch[1].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[2].en   = DISABLE;
		_cfg.ch[2].n_en = ENABLE;			//C-
		_cfg.ch[2].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		break;

	default:
		return;;
	}

	ald_timer_com_change_config(&Tim0Handle, &_cfg);
	return;
}

static void BLDC_MotorCommutation_CCW(uint16_t hallpos)
{
	switch (hallpos) {
	case 2:
		_cfg.ch[0].en   = DISABLE;			//
		_cfg.ch[0].n_en = ENABLE;			//A-
		_cfg.ch[0].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[1].en   = ENABLE;			//B+
		_cfg.ch[1].n_en = DISABLE;
		_cfg.ch[1].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[2].en   = DISABLE;
		_cfg.ch[2].n_en = DISABLE;
		_cfg.ch[2].mode = TIMER_OC_MODE_PWM1;
		break;

	case 3:
		_cfg.ch[0].en   = DISABLE;
		_cfg.ch[0].n_en = ENABLE;			//A-
		_cfg.ch[0].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[1].en   = DISABLE;
		_cfg.ch[1].n_en = DISABLE;
		_cfg.ch[1].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[2].en   = ENABLE;			//C+
		_cfg.ch[2].n_en = DISABLE;
		_cfg.ch[2].mode = TIMER_OC_MODE_PWM1;
		break;

	case 1:
		_cfg.ch[0].en   = DISABLE;
		_cfg.ch[0].n_en = DISABLE;
		_cfg.ch[0].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[1].en   = DISABLE;
		_cfg.ch[1].n_en = ENABLE;			//B-
		_cfg.ch[1].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[2].en   = ENABLE;			//C+
		_cfg.ch[2].n_en = DISABLE;
		_cfg.ch[2].mode = TIMER_OC_MODE_PWM1;
		break;

	case 5:
		_cfg.ch[0].en   = ENABLE;			//A+
		_cfg.ch[0].n_en = DISABLE;
		_cfg.ch[0].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[1].en   = DISABLE;
		_cfg.ch[1].n_en = ENABLE;			//B-
		_cfg.ch[1].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[2].en   = DISABLE;
		_cfg.ch[2].n_en = DISABLE;
		_cfg.ch[2].mode = TIMER_OC_MODE_PWM1;
		break;

	case 4:
		_cfg.ch[0].en   = ENABLE;			//A+
		_cfg.ch[0].n_en = DISABLE;
		_cfg.ch[0].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[1].en   = DISABLE;
		_cfg.ch[1].n_en = DISABLE;
		_cfg.ch[1].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		_cfg.ch[2].en   = DISABLE;
		_cfg.ch[2].n_en = ENABLE;			//C-
		_cfg.ch[2].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		break;

	case 6:
		_cfg.ch[0].en   = DISABLE;
		_cfg.ch[0].n_en = DISABLE;
		_cfg.ch[0].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[1].en   = ENABLE;			//B+
		_cfg.ch[1].n_en = DISABLE;
		_cfg.ch[1].mode = TIMER_OC_MODE_PWM1;
		_cfg.ch[2].en   = DISABLE;
		_cfg.ch[2].n_en = ENABLE;			//C-
		_cfg.ch[2].mode = TIMER_OC_MODE_FORCE_ACTIVE;
		break;

	default:
		return;;
	}

	ald_timer_com_change_config(&Tim0Handle, &_cfg);
	return;
}


void bsp_bldc_commutation(uint16_t hallpos)
{
	if (BLDC_MotorSpin == BLDC_CW) {
		BLDC_MotorCommutation_CW(hallpos);		
	} else {
		BLDC_MotorCommutation_CCW(hallpos);
	}	
}

void bsp_bldc_set_pwm(uint16_t PWM)
{
	AD16C4T0->CCVAL1 = PWM;
	AD16C4T0->CCVAL2 = PWM;
	AD16C4T0->CCVAL3 = PWM;
}

void bsp_bldc_stop(void)
{
	ald_timer_oc_stop(&Tim0Handle, TIMER_CHANNEL_1);
	ald_timer_ocn_stop(&Tim0Handle, TIMER_CHANNEL_1);
	ald_timer_oc_stop(&Tim0Handle, TIMER_CHANNEL_2);
	ald_timer_ocn_stop(&Tim0Handle, TIMER_CHANNEL_2);
	ald_timer_oc_stop(&Tim0Handle, TIMER_CHANNEL_3);
	ald_timer_ocn_stop(&Tim0Handle, TIMER_CHANNEL_3);
}

void bsp_bldc_sw(void)
{
	if ( BLDC_MotorSpin == BLDC_CCW)
		BLDC_MotorSpin = BLDC_CW;
	else 
		BLDC_MotorSpin = BLDC_CCW;
}

void bsp_bldc_s(void)
{
	ald_gpio_toggle_pin(GPIOD, GPIO_PIN_1);
}


uint16_t BLDC_speed_calc(void)
{
	uint16_t speed = 0;
	speed = (uint16_t)(10000/(scnt * 24))*60;
	return speed;
}
