/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
uint8_t rx_flag = 0;
uint8_t rx_buf[8] = {0};

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to can_handle_t structure.
  * @retval None.
  */
void uart_bt_send_complete(uart_handle_t *arg)
{
	return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to can_handle_t structure.
  * @retval None.
  */
void uart_bt_recv_complete(uart_handle_t *arg)
{
	return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to can_handle_t structure.
  * @retval None.
  */
void uart_bt_error(uart_handle_t *arg)
{
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	ald_mcu_irq_config(BS16T2_UART3_IRQn, 3, ENABLE);
	uart_bt_module_init(9600);

	while (1) {
		ald_delay_ms(1000);
		bsp_uart_bt_send(rx_buf, 1);
	}
}

/**
  * @}
  */
/**
  * @}
  */
