/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
can_tx_msg_t tx_msg;
can_rx_msg_t rx_msg;
can_filter_t can_filt;

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Initialize can */
	can_module_init();

	/* Initialize send msg */
	memset(&tx_msg.data, 0x55, sizeof(tx_msg.data));

	/* Send a message */
	can_send_msg(tx_msg);

	can_filt.id_high      = 0;
	can_filt.id_low       = 0;
	can_filt.mask_id_high = 0;
	can_filt.mask_id_low  = 0;
	can_filt.fifo         = CAN_FILTER_FIFO0;
	can_filt.number       = 0;
	can_filt.mode         = CAN_FILTER_MODE_MASK;
	can_filt.scale        = CAN_FILTER_SCALE_32;
	can_filt.active	    = ENABLE;
	ald_can_filter_config(&h_can, &can_filt);

	/* Receive a message */
	can_recv_msg(&rx_msg);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
