/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"
#include "ke.h"
#include "string.h"

uint8_t buf_tx[10] = {0};
uint8_t buf_rx[10] = {0};

static void lcd_cs_set(void)
{
	gpio_init_t x;

	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;

	ald_gpio_init(GPIOE, GPIO_PIN_14, &x);
	ald_gpio_write_pin(GPIOE, GPIO_PIN_14, 1);

	ald_gpio_init(GPIOE, GPIO_PIN_15, &x);
	ald_gpio_write_pin(GPIOE, GPIO_PIN_15, 1);
}
/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Set system clock to 48MHz */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	
	memset(buf_tx, 0x55, sizeof(buf_tx));
	lcd_cs_set();

	/* Initialize w25q32 */
	w25q32_module_init();

	w25q32_sector_erase(0);
	ald_delay_ms(1000);
	w25q32_write(0, buf_tx, sizeof(buf_tx));
	ald_delay_ms(1000);
	w25q32_read(0, buf_rx, sizeof(buf_rx));

	while(1) {
		ald_delay_ms(1000);
	}
}
