/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"
#include "ke.h"
#include "string.h"

uint8_t buf_tx[10] = {0};
uint8_t buf_rx[10] = {0};

/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Set system clock to 48MHz */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	
	memset(buf_tx, 0x50, sizeof(buf_tx));

	/* Enable i2c interrupt */
	ald_mcu_irq_config(I2C1_IRQn, 3, ENABLE);

	/* Initialize eeprom */
	eeprom_module_init();
	
	write_eeprom(0xA2, 0, I2C_MEMADD_SIZE_8BIT, buf_tx, sizeof(buf_tx));
	ald_delay_ms(200);
	read_eeprom(0xA2, 0, I2C_MEMADD_SIZE_8BIT, buf_rx, sizeof(buf_rx));
	
	while(1) {
		ald_delay_ms(1000);
	}
}
