/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/**
  * @brief RGB module lptim0 structure
  */
typedef struct rgb_lptim_env_s {
#ifdef ES32F0334
	lptim_handle_t lptim_h;
	lptim_trigger_init_t lptim_trig;
	lptim_clock_source_init_t lptim_clk;
#else
	timer_handle_t lptim_h;
	timer_oc_init_t lptim_trig;
	timer_clock_config_t lptim_clk;
#endif
}rgb_lptim_env_t;

rgb_lptim_env_t lptim;
rgb_tim3_env_t   tim3;
uint16_t duty = 0;
uint8_t flag = 1;
/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	uint8_t cnt_id = 0;

	/* Initialize ALD */
	ald_cmu_init();
	/* Set system clock to 48MHz */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Initialize kernel */
	rgb_module_init(&tim3, &lptim);
	
	while(1) {
		ald_delay_ms(10);	
		switch (cnt_id)
		{
			case 0:
				lptim_pwm_set_duty(&lptim, duty);
				break;
			case 1:
				ald_timer_pwm_set_duty(&tim3.tim_h, TIMER_CHANNEL_1, duty);
				break;
			case 2:
				ald_timer_pwm_set_duty(&tim3.tim_h, TIMER_CHANNEL_2, duty);
				break;
			default:
				break;
		}

		if (flag) {
			duty++;
		}
		else {
			duty--;
		}
		
		if (duty > 99) {
			flag = 0;
		}

		if (duty < 1) {
			flag = 1;
			cnt_id++;
		}

		if (cnt_id > 3)
			cnt_id = 0;
	}
}
