/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   bootloader
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"
#include "ke.h"
#include "bsp_key.h"


#define TASK_KEY_PRIO	20

ke_que_t *que;
bsp_key_event_t tmp;

/**
  * @brief  Callback function of key's event.
  * @param  event: Type of key's event.
  * @retval None
  */
void key_proc(bsp_key_event_t event)
{
	ke_msg_t *msg;
	
	if ((msg = (ke_msg_t *)ke_malloc(sizeof(ke_msg_t))) == NULL)
		KE_PANIC();
	
	msg->rsv = (uint32_t)event;
	que_enq(que, msg);

	return;
}

/**
  * @brief  Callback function of 10ms interrupt.
  * @retval None
  */
void ke_10ms_irq_cbk()
{
	bsp_key_scan();
	return;
}

/**
  * @brief  Callback function of key's task.
  * @param  arg: Pointer to parameter.
  * @retval None
  */
void task_key_func(void *arg)
{
	ke_msg_t *msg;

	if ((msg = que_deq(que)) == NULL)
		return;
	
	tmp = (bsp_key_event_t)msg->rsv;
	UNUSED(tmp);
	free(msg);
	
	return;
}

/**
  * @brief  This is main function.
  *         Detect running time.
  * @retval Status
  */
int main()
{
	ald_cmu_init();
	ald_cmu_auto_calib_clock(CMU_AUTO_CALIB_INPUT_LOSE, CMU_AUTO_CALIB_OUTPUT_24M);
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

        #if defined (__ICCARM__)
	ke_init(0x8000, NULL, 0x800);
        #else
	ke_init(0x8000, NULL);
        #endif

	task_create(task_key_func, NULL, TASK_KEY_PRIO);
	if ((que = que_create(TASK_KEY_PRIO)) == NULL)
		KE_PANIC();

	bsp_key_init();
	bsp_key_bond_func(BSP_KEY_ALL, key_proc);


	ke_start();
}
