/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   bootloader
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"

#define BOOT_REQ	0xA0
#define BOOT_RSP	0xA1
#define BOOT_ACT	0xA2
#define BOOT_RACT	0xA3
#define BOOT_PACK	0xA4
#define BOOT_FW		0xA5
#define BOOT_CHIP	0xA6
#define PACK_OK		0xA7
#define PACK_ERR	0xA8
#define PACK_END	0xA9
#define REBOOT_CHIP_KEY	0x8B9C7A6E

typedef struct pack_hdr_s {
	uint16_t len;
	uint32_t sum;
} pack_hdr_t;

#endif
