/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#ifndef __MAIN_H__
#define __MAIN_H__

#include "ald_conf.h"
#include "stdio.h"
#include "bsp_rtc.h"
#include "bsp_key.h"
#include "bsp_dht11.h"
#include "bsp_micro_sd.h"
#include "bsp_mpu9250.h"
#include "bsp_micro_sd.h"
#include "ald_adc.h"
#include "bsp_w5500.h"
#include "bsp_display.h"
#include "bsp_rgb.h"
#include "bsp_adc.h"
#include "bsp_led.h"
#include "ke.h"
/**
  * @addtogroup GUI TFT Screen GUI Module
  * @{
  */

/**
  * @defgroup GUI_Private_Types GUI Private Types
  * @{
  */
#define CHIP1 654
#define CHIP2 334

#define TASK_PRESS_PRIO 9  /* screen opreat task */
#define TASK_RTC_PRIO  	10 /* rtc second irq task */
#define TASK_MENU_PRIO  11 /* menu  opreat task*/
#define TASK_CHIP_PRIO	12 /* chip info show task */
#define TASK_LED_PRIO	13 /* LED task */
#define TASK_RGB_PRIO	14 /* RGB task */
#define TASK_KEY_PRIO	16 /* KEY task */
#define TASK_ADC_PRIO	17 /* ADC task */
#define TASK_TEMP_PRIO	18 /* TEMP task */
#define TASK_TF_PRIO	19 /* TF CARD task */
#define TASK_GYRO_PRIO	20 /* GYRO task */
#define TASK_ETH_PRIO	21 /* ETH task */

/**
  * @brief LED module structure
  */
typedef struct led_env_s{
	uint16_t led_10ms;
}led_env_t;

/**
  * @brief screen Press module structure
  */
typedef struct pre_env_s{
	ke_sem_t *sem_press;
}pre_env_t;

/**
  * @brief Menu module structure
  */
typedef struct menu_env_s{
	uint8_t  wait;
	ke_sem_t *sem_menu;
}menu_env_t;

/**
  * @brief GYPO module structure
  */
typedef struct gyro_env_s {
	bsp_mpu9250_env_t h_mpu;
	uint8_t ms_10;
	ke_sem_t *sem_gyro;
}gyro_env_t;

/**
  * @brief RGB module duty structure
  */
typedef struct rgb_duty_s {
	int8_t  red_duty;
	int8_t  green_duty;
	int8_t  blue_duty;
	uint8_t red_flag;
	uint8_t green_flag;
	uint8_t blue_flag;
	uint8_t count_tran;
}rgb_duty_t;

/**
  * @brief RGB module lptim0 structure
  */
typedef struct rgb_lptim_env_s {
#ifdef ES32F0334
	lptim_handle_t lptim_h;
	lptim_trigger_init_t lptim_trig;
	lptim_clock_source_init_t lptim_clk;
#else
	timer_handle_t lptim_h;
	timer_oc_init_t lptim_trig;
	timer_clock_config_t lptim_clk;
#endif
}rgb_lptim_env_t;

/**
  * @brief RGB module tim3 structure
  */
typedef struct rgb_tim_env_s {
	timer_handle_t tim3_h;
	timer_oc_init_t tim3_ocinit;
	timer_clock_config_t tim3_clock;
}rgb_tim_env_t;

/**
  * @brief RGB module structure
  */
typedef struct rgb_env_s {
	rgb_tim_env_t tim;
	rgb_lptim_env_t lptim;
	rgb_duty_t rgb_duty;
	ke_sem_t *sem_rgb;
}rgb_env_t;

/**
  * @brief chip module structure
  */
typedef struct chip_env_s {
	ke_sem_t *sem_chip;
} chip_env_t;

/**
  * @brief KEY module structure
  */
typedef struct key_env_s {
	ke_que_t *que_key;
	bsp_key_event_t tmp;
} key_env_t;

/**
  * @brief RTC module structure
  */
typedef struct rtc_env_s {
	rtc_time_t time;
	rtc_date_t date;
	rtc_init_t init;
	uint16_t   sec;
	ke_sem_t   *sem_rtc;
} rtc_env_t;

/**
  * @brief ETH module structure
  */
typedef struct eth_env_s {
	uint16_t ms_10;
	uint8_t  con_err;
	ke_sem_t *sem_eth;
} eth_env_t;

/**
  * @brief ADC module structure
  */
typedef struct adc_env_s {
	uint16_t ms_10;
	ke_sem_t *sem_adc;
} adc_env_t;

/**
  * @brief application environment structure
  */
typedef struct app_env_s {
	pre_env_t  app_pre;
	menu_env_t app_menu;
	adc_env_t  app_adc;
	led_env_t  app_led;
	rtc_env_t  app_rtc;
	key_env_t  app_key;
	chip_env_t app_chip;
	rgb_env_t  app_rgb;
	uint16_t   chip_type;
	gyro_env_t app_gyro;
	eth_env_t  app_eth;
	uint8_t	   screen_index;
	uint8_t    busy_flag;
} app_env_t;

/**
  * @}
  */

/**
  * @addtogroup GUI_Public_Functions
  * @{
  */
__isr__ extern void rtc_irq_handler(void);
extern bsp_display_env_t disp_env;
extern app_env_t app_env;
extern adc_handle_t h_adc;

/**
  * @}
  */

/**
  * @}
  */

#endif
