/**
  *********************************************************************************
  *
  * @file    ald_conf.h
  * @brief   Enable/Disable the peripheral module.
  *
  * @version V1.0
  * @date    18 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          18 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */


#ifndef __ALD_CONF_H__
#define __ALD_CONF_H__

/* Includes ------------------------------------------------------------------ */

#define ALD_DMA
#define ALD_GPIO
#define ALD_UART
#define ALD_USART
#define ALD_SMARTCARD	/* The ALD_SMARTCARD depend on ALD_USART */
#define ALD_I2C
#define ALD_CMU
#define ALD_RMU
#define ALD_PMU
#define ALD_WDT
#define ALD_RTC
#define ALD_FLASH
#define ALD_ADC
#define ALD_CRC
#define ALD_CRYPT
#define ALD_TIMER
#define ALD_LPTIM
#define ALD_PIS
#define ALD_SPI
#define ALD_CALC
#define ALD_ACMP
#define ALD_TRNG
#define ALD_TSENSE
#define ALD_BKPC
#define ALD_IAP

#ifdef ALD_GPIO
	#include "ald_gpio.h"
#endif	/*ALD_GPIO */

#ifdef ALD_DMA
	#include "ald_dma.h"
#endif	/* ALD_DMA */

#ifdef ALD_UART
	#include "ald_uart.h"
#endif	/* ALD_UART */

#ifdef ALD_USART
	#include "ald_usart.h"
#endif	/* ALD_USART */

#ifdef ALD_SMARTCARD	/* The ALD_SMARTCARD depend on ALD_USART */
	#include "ald_smartcard.h"
#endif	/* ALD_SMARTCARD */

#ifdef ALD_I2C
	#include "ald_i2c.h"
#endif	/* ALD_I2C */

#ifdef ALD_CMU
	#include "ald_cmu.h"
#endif	/* ALD_CMU */

#ifdef ALD_RMU
	#include "ald_rmu.h"
#endif	/* ALD_RMU */

#ifdef ALD_PMU
	#include "ald_pmu.h"
#endif	/* ALD_PUM */

#ifdef ALD_WDT
	#include "ald_wdt.h"
#endif	/* ALD_WDT */

#ifdef ALD_LCD
	#include "ald_lcd.h"
#endif	/* ALD_LCD */

#ifdef ALD_RTC
	#include "ald_rtc.h"
#endif	/* ALD_RTC */

#ifdef ALD_FLASH
	#include "ald_flash.h"
#endif	/*ALD_FLASH*/

#ifdef ALD_ADC
	#include "ald_adc.h"
#endif	/* ALD_ADC */

#ifdef ALD_CRC
	#include "ald_crc.h"
#endif	/* ALD_CRC */

#ifdef ALD_CRYPT
	#include "ald_crypt.h"
#endif	/* ALD_CRYPT */

#ifdef ALD_TIMER
	#include "ald_timer.h"
#endif	/* ALD_TIMER */

#ifdef ALD_PIS
	#include "ald_pis.h"
#endif	/* ALD_PIS */

#ifdef ALD_SPI
	#include "ald_spi.h"
#endif	/* ALD_SPI */

#ifdef ALD_CALC
	#include "ald_calc.h"
#endif	/* ALD_CALC */

#ifdef ALD_ACMP
	#include "ald_acmp.h"
#endif	/* ALD_ACMP */

#ifdef ALD_OPAMP
	#include "ald_opamp.h"
#endif	/* ALD_OPAMP */

#ifdef ALD_TRNG
	#include "ald_trng.h"
#endif	/* ALD_TRNG */

#ifdef ALD_TSENSE
	#include "ald_tsense.h"
#endif	/* ALD_TSENSE */

#ifdef ALD_BKPC
	#include "ald_bkpc.h"
#endif	/* ALD_BKPC */

#ifdef ALD_DAC
	#include "ald_dac.h"
#endif	/* ALD_DAC */

#ifdef ALD_IAP
	#include "ald_iap.h"
#endif	/* ALD_IAP */

#define TICK_INT_PRIORITY	3

#endif
