/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"
#include <stdlib.h>

/** @addtogroup Projects_Templates_MD
  * @{
  */

/** @addtogroup Templates
  * @{
  */
uint32_t tick0;
uint32_t tick1;
uint32_t time;

/**
  * @brief  This is main function.
  *         Detect running time.
  * @retval Status
  */
int main()
{
	uint32_t i;
	uint32_t com;

	/* Initialize 1ms tick */
	md_init_1ms_tick();
	/* Get first tick */
	tick0 = md_get_tick();

	/* do something */
	for (i = 0; i < 0xff; ++i) {
		com = 1;
		com = i + com + 3;
		com = com + 24;
	}

	/* Get second tick */
	tick1 = md_get_tick();
	/* time = (tick1 -tick0) * 1 / flck */
	time  = tick1 - tick0;

	while (1) {
		md_delay_1ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
