/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <stdlib.h>
#include "main.h"
#include "ke.h"


/** @addtogroup Projects_Examples_Micro_Kernel
  * @{
  */

/** @addtogroup Examples
  * @{
  */

#define TESP_TASK1_PRIO	6
#define TESP_TASK2_PRIO	7
#define TESP_TASK3_PRIO	8


ke_sem_t *sem;

/**
  * @brief  Callback function of test's task.
  * @param  arg: Pointer to parameter.
  * @retval None
  */
void test_task1_func(void *arg)
{
	int32_t var;

	if (sem_pend(sem))
		return;
	
	var = 4;
	var = var;
	
	return;
}

/**
  * @brief  Callback function of test's task.
  * @param  arg: Pointer to parameter.
  * @retval None
  */
void test_task2_func(void *arg)
{
	sem_post(sem);
	return;
}


/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Set system clock to 48MHz */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Initialize kernel */
        #if defined (__ICCARM__)
	ke_init(0x8000, NULL, 0x800);
        #else
	ke_init(0x8000, NULL);
        #endif

	task_create(test_task1_func, NULL, TESP_TASK1_PRIO);
	task_create(test_task2_func, NULL, TESP_TASK2_PRIO);

	if ((sem = sem_create(TESP_TASK1_PRIO)) == NULL)
		KE_PANIC();
	
	/* Start kernel */
	ke_start();
	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
