/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

md_uart_init_t init;
uint8_t tx_buf[32];
uint8_t rx_buf[32];

/**
  * @brief  Initializate pin
  * @retval None
  */
void uart_pin_init(void)
{
	md_gpio_init_t x;

	/* Initialize tx pin */
	x.mode = MD_GPIO_MODE_OUTPUT;
	x.odos = MD_GPIO_PUSH_PULL;
	x.pupd = MD_GPIO_PUSH_UP;
	x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
	x.flt  = MD_GPIO_FILTER_DISABLE;
	x.type = MD_GPIO_TYPE_TTL;
	x.func = MD_GPIO_FUNC_3;
	md_gpio_init(UART1_TX_PORT, UART1_TX_PIN, &x);

	/* Initialize rx pin */
	x.mode = MD_GPIO_MODE_INPUT;
	x.odos = MD_GPIO_PUSH_PULL;
	x.pupd = MD_GPIO_PUSH_UP;
	x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
	x.flt  = MD_GPIO_FILTER_DISABLE;
	x.type = MD_GPIO_TYPE_TTL;
	x.func = MD_GPIO_FUNC_3;
	md_gpio_init(UART1_RX_PORT, UART1_RX_PIN, &x);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize 1ms tick */
	md_init_1ms_tick();

	/* clear md_uart_init_t structure */
	memset(&init, 0x0, sizeof(md_uart_init_t));
	/* Initialize pin */
	uart_pin_init();
	/* Initialize tx_buf */
	memset(tx_buf, 0x55, 32);

	/* Initialize UART */
	init.baud        = 115200;
	init.word_length = MD_UART_WORD_LENGTH_8B;
	init.stop_bits   = MD_UART_STOP_BITS_1;
	init.parity      = MD_UART_PARITY_NONE;
	init.fctl        = MD_UART_FLOW_CTL_DISABLE;
	md_uart_init(UART1, &init);

	/* Send a message */
	md_uart_send_data8(UART1, tx_buf[0]);
	/* Receive a message */
	rx_buf[0] = (uint8_t)md_uart_recv_data8(UART1);

	while (1) {
		md_delay_1ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
