/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initialize LED.
  * @param  None
  * @retval None
  */
void led_init(void)
{
	md_gpio_set_pin_function(LED_GPIO_PORT, LED_GPIO_PIN, MD_GPIO_FUNC_1);
	md_gpio_set_pin_push_pull(LED_GPIO_PORT, LED_GPIO_PIN);
	md_gpio_set_pin_mode_output(LED_GPIO_PORT, LED_GPIO_PIN);
}

/**
  * @brief  Initialize TIMER.
  * @param  None
  * @retval None
  */
void timer_base_init(void)
{
	md_timer_base_init_t init;

	md_mcu_irq_config(GP16C4T0_BRK_UP_TRIG_COM_IRQn, 1, ENABLE);
	md_timer_base_struct_init(&init);
	init.prescaler = 64;
	md_timer_base_set_config(GP16C4T0, &init);
	md_timer_enable_uit_interrupt(GP16C4T0);
	md_timer_enable_counter_cnten(GP16C4T0);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
        /* Initialize LED */
        led_init();
	/* Initialize timer */
	timer_base_init();

	while(1) {
		;
	}
}

/**
  * @}
  */
/**
  * @}
  */

