/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    17 Nov 2017
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#include "main.h"
#include "md_tim.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
	while (1)
		;
}

/**
  * @brief  UART IRQ handler
  * @retval None
  */
void UART0_Handler(void)
{	
	/* Handle uart interrupt */
	
	return;
}

/**
  * @brief  TIM2 IRQ handler
  * @retval None
  */
void GP16C4T0_BRK_UP_TRIG_COM_Handler(void)
{	
	/* Handle TIM interrupt */
	if(md_timer_get_update_valid_interrupt_flag_uei(GP16C4T0) == 1)
	{
		md_timer_clear_update_interrupt_flag_ueic(GP16C4T0);
		md_gpio_toggle_pin_output(LED2_GPIO_PORT, LED2_GPIO_PIN);
	}
	return;
}


/**
  * @}
  */
/**
  * @}
  */
