/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  This function configures GPIO
  * @param  None
  * @retval None
  */
void config_gpio(void)
{
	md_gpio_set_pin_drive_normal(TOGGLE_GPIO_PORT, TOGGLE_GPIO_PIN);
	md_gpio_set_pin_push_up(TOGGLE_GPIO_PORT, TOGGLE_GPIO_PIN);
	md_gpio_set_pin_function(TOGGLE_GPIO_PORT, TOGGLE_GPIO_PIN, MD_GPIO_FUNC_2);
	md_gpio_set_pin_push_pull(TOGGLE_GPIO_PORT, TOGGLE_GPIO_PIN);
	md_gpio_set_pin_mode_output(TOGGLE_GPIO_PORT, TOGGLE_GPIO_PIN);
}

/**
  * @brief  This is main function
  * @retval Status
  */

int main()
{
	md_lptim_init_t init;

	/* Initialize LPTIM0 */
	config_gpio();

        md_mcu_irq_config(LPTIM0_SPI2_IRQn,1,ENABLE);
	
	SYSCFG_UNLOCK();	
	md_cmu_set_lptim0_clock_source(0x8);
	SYSCFG_LOCK();
	
	init.psc  = MD_LPTIM_PRESC_1;
	init.arr  = 0xFFF;
	init.mode = MD_LPTIM_MODE_CONTINUOUS;
	md_lptim_base_init(LPTIM0, &init);
	
	md_lptim_set_output_state(LPTIM0, 0x01);
	md_lptim_set_clock_source(LPTIM0, 0x0);
	md_lptim_set_clock_edge(LPTIM0,0x0);
	
	md_lptim_set_trigger_polarity(LPTIM0, 0x0);
	md_lptim_set_trigger_source(LPTIM0, 0x0);

	/* Initialize toggle */
	md_lptim_enable_arrmie_intrrupt(LPTIM0);
	/* Start LPTIM0 */
	md_lptim_enable(LPTIM0);
	md_lptim_set_continuous_mode(LPTIM0);

	while(1);
}
/**
  * @}
  */
/**
  * @}
  */
