/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for demo
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_ADC
  * @{
  */

/**
  * @brief  Initializate buf of adc normal value.
  */
uint32_t nm_value;
/**
  * @brief  adc_handle_t structure.
  */
md_adc_init_t h_adc;
md_adc_nch_conf_t conf;

/**
  * @brief  Initializate pin of adc module.
  * @retval None
  */
void adc_pin_init(void)
{
	md_gpio_init_t x;

	memset(&x, 0x0, sizeof(md_gpio_init_t));
	
	/* Initialize sck pin */
	x.mode = MD_GPIO_MODE_INPUT;
	x.pupd = MD_GPIO_PUSH_UP;
	x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
	x.flt  = MD_GPIO_FILTER_DISABLE;
	x.type = MD_GPIO_TYPE_CMOS;
	x.func = MD_GPIO_FUNC_0;
	md_gpio_init(GPIO_CH_PORT, ADC_CH1_PIN, &x);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize 1ms tick */
	md_init_1ms_tick();
	/* clear adc_handle_t structure */
	memset(&h_adc, 0x0, sizeof(h_adc));
	/* Initialize adc pin */
	adc_pin_init();

	/* Initialize ADC0 */
	md_adc_struct_init(&h_adc);
	md_adc_init(ADC0, &h_adc);

	/* Configure normal channel */
	md_adc_normal_struct_init(&conf);
	md_adc_normal_channel_config(ADC0, &conf);

	/* Enable ADC0 */
	MD_ADC_ENABLE(ADC0);

	/* Start normal convert */
	md_adc_set_normal_channel_conv_start_nchtrg(ADC0);
	/* Wait convert finish */
	while (md_adc_get_stat_nche(ADC0) == 0);
	/* Clear complete flag */
	md_adc_set_clr_nche(ADC0);
	/* Read normal convert result */
	nm_value = md_adc_get_normal_channel_val(ADC0);

	while (1) {		
		md_delay_1ms(1000);
		/* Start normal convert */
		md_adc_set_normal_channel_conv_start_nchtrg(ADC0);
		/* Wait convert finish */
		while (md_adc_get_stat_nche(ADC0) == 0);
		/* Clear complete flag */
		md_adc_set_clr_nche(ADC0);
		/* Read normal convert result */
		nm_value = md_adc_get_normal_channel_val(ADC0);
	}
}
/**
  * @}
  */
/**
  * @}
  */
