/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

lpuart_handle_t h_lpuart;
md_lpuart_init_t init;
uint8_t tx_buf[32];
uint8_t rx_buf[32];

/**
  * @brief  Initializate pin of lpuart module.
  * @retval None
  */
void lpuart_pin_init(void)
{
	gpio_init_t x;

	/* Initialize tx pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_2;
	ald_gpio_init(LPUART0_TX_PORT, LPUART0_TX_PIN, &x);

	/* Initialize rx pin */
	x.mode = GPIO_MODE_INPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_2;
	ald_gpio_init(LPUART0_RX_PORT, LPUART0_RX_PIN, &x);

	return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to lpuart_handle_t structure.
  * @retval None.
  */
void lpuart_send_complete(lpuart_handle_t *arg)
{
	return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to lpuart_handle_t structure.
  * @retval None.
  */
void lpuart_recv_complete(lpuart_handle_t *arg)
{
	return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to lpuart_handle_t structure.
  * @retval None.
  */
void lpuart_error(lpuart_handle_t *arg)
{
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	/* clear md_lpuart_init_t structure */
	memset(&init, 0x0, sizeof(md_lpuart_init_t));
	/* clear lpuart_handle_t structure */
	memset(&h_lpuart, 0x0, sizeof(h_lpuart));
	/* Initialize pin */
	lpuart_pin_init();
	/* Initialize tx_buf */
	memset(tx_buf, 0x55, 32);

	/* Initialize LPUART */
	h_lpuart.perh             = LPUART0;
	h_lpuart.init.baud        = 2400;
	h_lpuart.init.word_length = LPUART_WORD_LENGTH_8B;
	h_lpuart.init.stop_bits   = LPUART_STOP_BITS_1;
	h_lpuart.init.parity      = LPUART_PARITY_NONE;
	h_lpuart.init.mode        = LPUART_MODE_UART;
	h_lpuart.init.fctl        = LPUART_HW_FLOW_CTL_NONE;
	h_lpuart.init.clock       = CMU_LP_PERH_CLOCK_SEL_LRC;
	h_lpuart.tx_cplt_cbk      = lpuart_send_complete;
	h_lpuart.rx_cplt_cbk      = lpuart_recv_complete;
	h_lpuart.error_cbk        = lpuart_error;

	init.baud        = 2400;
	init.word_length = MD_LPUART_WORD_LENGTH_8B;
	init.stop_bits   = MD_LPUART_STOP_BITS_1;
	init.parity      = MD_LPUART_PARITY_NONE;
	init.mode        = MD_LPUART_MODE_UART;
	init.fctl        = MD_LPUART_FLOW_CTL_DISABLE;
	md_lpuart_init(LPUART0, &init);

	/* Send a message */
	h_lpuart.state = LPUART_STATE_READY;
	ald_lpuart_send(&h_lpuart, tx_buf, 32, 1000);
	/* Receive a message */
	h_lpuart.state = LPUART_STATE_READY;
	ald_lpuart_recv(&h_lpuart, rx_buf, 8, 10000);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
