/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Apr 2017
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          17 Apr 2017     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

i2c_handle_t h_i2c;
uint8_t buffer[10] = {0};
uint8_t read[10] = {0};

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void i2c_pin_init(void)
{
	gpio_init_t a;
	
	/* Initialize scl pin */
	a.mode = GPIO_MODE_OUTPUT;
	a.odos = GPIO_PUSH_PULL;
	a.pupd = GPIO_PUSH_UP;
	a.odrv = GPIO_OUT_DRIVE_NORMAL;
	a.flt  = GPIO_FILTER_DISABLE;
	a.type = GPIO_TYPE_CMOS;
	a.func = GPIO_FUNC_5;
	ald_gpio_init(I2C1_SCL_PORT, I2C1_SCL_PIN, &a);

	/* Initialize sda pin */
	a.mode = GPIO_MODE_OUTPUT;
	a.odos = GPIO_PUSH_PULL;
	a.pupd = GPIO_PUSH_UP;
	a.odrv = GPIO_OUT_DRIVE_NORMAL;
	a.flt  = GPIO_FILTER_DISABLE;
	a.type = GPIO_TYPE_CMOS;
	a.func = GPIO_FUNC_5;
	ald_gpio_init(I2C1_SDA_PORT, I2C1_SDA_PIN, &a);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	
	/* clear i2c_handle_t structure */
	memset(&h_i2c, 0, sizeof(i2c_handle_t));
	/* Initialize tx_buf */
	memset(buffer, 0x57, 10);
	/* Initialize pin */
	i2c_pin_init();

	h_i2c.perh = I2C1;

	/* Initialize I2C */
	md_i2c_struct_init((md_i2c_init_t*)&h_i2c.init);
	md_i2c_init(h_i2c.perh, (md_i2c_init_t*)&h_i2c.init);

	h_i2c.error_code = I2C_ERROR_NONE;
	h_i2c.state      = I2C_STATE_READY;
	h_i2c.mode       = I2C_MODE_NONE;
	
	/* Send a message to salve device's address is 0xA0 */
	ald_i2c_master_send(&h_i2c, 0xA0, buffer, 1, 5000);

	/* Receive a message from salve advice's address is 0xA0 */
	ald_i2c_master_recv(&h_i2c, 0xA0, read, 1, 5000);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
